/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.disenchanting_table.core.world.block.entity.util;

import forge.com.cursee.disenchanting_table.core.world.block.entity.util.ModBlockEntity;
import forge.com.cursee.disenchanting_table.core.world.block.entity.util.SimpleInventoryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class SimpleInventoryBlockEntity
extends ModBlockEntity
implements Clearable {
    private final SimpleContainer itemHandler = this.createItemHandlerInstance();

    public SimpleInventoryBlockEntity(BlockEntityType<? extends BlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemHandler.addListener(container -> this.setChanged());
    }

    public abstract int inventorySize();

    protected abstract SimpleContainer createItemHandlerInstance();

    public final SimpleContainer getItemHandler() {
        return this.itemHandler;
    }

    public void clearContent() {
        this.getItemHandler().clearContent();
    }

    @Override
    public void writePacketData(ValueOutput output) {
        ContainerHelper.saveAllItems((ValueOutput)output, SimpleInventoryHelper.copyFromInv((Container)this.itemHandler));
    }

    @Override
    public void readPacketData(ValueInput input) {
        NonNullList temporary = NonNullList.withSize((int)this.inventorySize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)input, (NonNullList)temporary);
        SimpleInventoryHelper.copyToInv((NonNullList<ItemStack>)temporary, (Container)this.itemHandler);
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        ContainerHelper.saveAllItems((ValueOutput)output, (NonNullList)this.itemHandler.getItems());
        super.saveAdditional(output);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        NonNullList temporary = NonNullList.withSize((int)this.inventorySize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)input, (NonNullList)temporary);
        SimpleInventoryHelper.copyToInv((NonNullList<ItemStack>)temporary, (Container)this.itemHandler);
    }

    public void setInventory(NonNullList<ItemStack> items) {
        for (int i = 0; i < items.size(); ++i) {
            this.getItemHandler().setItem(i, (ItemStack)items.get(i));
        }
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        SimpleInventoryBlockEntity simpleInventoryBlockEntity = this;
        if (simpleInventoryBlockEntity instanceof Container) {
            Container container = (Container)simpleInventoryBlockEntity;
            if (this.level != null) {
                Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)container);
            }
        }
    }

    @Override
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::saveCustomOnly);
    }
}

