/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.disenchanting_table.core.world.inventory;

import forge.com.cursee.disenchanting_table.core.registry.ModMenus;
import forge.com.cursee.disenchanting_table.core.util.DisEnchantingHelper;
import forge.com.cursee.disenchanting_table.core.world.inventory.IDisplayInventory;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class DisEnchantingTableMenu
extends AbstractContainerMenu
implements IDisplayInventory {
    public static final int SLOT_Y_POS = 47;
    Container container;
    ContainerData containerData;
    List<Integer> inputSlotIndexes = List.of(Integer.valueOf(0), Integer.valueOf(1));

    public DisEnchantingTableMenu(int containerID, Inventory inventory) {
        this(containerID, inventory, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(1));
    }

    public DisEnchantingTableMenu(int containerId, Inventory inventory, Container container, ContainerData containerData) {
        super((MenuType)ModMenus.DISENCHANTING_TABLE.get(), containerId);
        DisEnchantingTableMenu.checkContainerSize((Container)container, (int)3);
        DisEnchantingTableMenu.checkContainerDataCount((ContainerData)containerData, (int)1);
        this.container = container;
        this.containerData = containerData;
        this.addSlot(new Slot(this, this.container, 0, 27, 47){

            public boolean mayPlace(ItemStack stack) {
                return DisEnchantingHelper.canDisenchant(stack);
            }
        });
        this.addSlot(new Slot(this, this.container, 1, 76, 47){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(Items.BOOK);
            }
        });
        this.addSlot(new Slot(this, this.container, 2, 134, 47){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)inventory, column + row * 9 + 9, 8 + column * 18, 84 + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)inventory, column, 8 + column * 18, 142));
        }
    }

    public int progress() {
        return this.containerData.get(0);
    }

    @Override
    public int getResultSlot() {
        return 2;
    }

    protected boolean canMoveIntoInputSlots(ItemStack stack) {
        return DisEnchantingHelper.canDisenchant(stack) || stack.is(Items.BOOK);
    }

    public int getSlotToQuickMoveTo(ItemStack stack) {
        return stack.is(Items.BOOK) ? 1 : 0;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        int moveTo;
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return stack;
        }
        ItemStack stackInSlot = slot.getItem();
        stack = stackInSlot.copy();
        int inventorySlotStart = this.getInventorySlotStart();
        int useRowEnd = this.getUseRowEnd();
        if (index == this.getResultSlot()) {
            if (!this.moveItemStackTo(stackInSlot, inventorySlotStart, useRowEnd, true)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(stackInSlot, stack);
        } else if (this.inputSlotIndexes.contains(index) ? !this.moveItemStackTo(stackInSlot, inventorySlotStart, useRowEnd, false) : (this.canMoveIntoInputSlots(stackInSlot) && index >= this.getInventorySlotStart() && index < this.getUseRowEnd() ? !this.moveItemStackTo(stackInSlot, moveTo = this.getSlotToQuickMoveTo(stack), this.getResultSlot(), false) : (index >= this.getInventorySlotStart() && index < this.getInventorySlotEnd() ? !this.moveItemStackTo(stackInSlot, this.getUseRowStart(), this.getUseRowEnd(), false) : index >= this.getUseRowStart() && index < this.getUseRowEnd() && !this.moveItemStackTo(stackInSlot, this.getInventorySlotStart(), this.getInventorySlotEnd(), false)))) {
            return ItemStack.EMPTY;
        }
        if (stackInSlot.isEmpty()) {
            slot.setByPlayer(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stackInSlot.getCount() == stack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stackInSlot);
        return stack;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }
}

