/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.disenchanting_table;

import com.cursee.moandjiezana.toml.Toml;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import neoforge.com.cursee.disenchanting_table.Constants;
import neoforge.com.cursee.disenchanting_table.DisEnchantingTable;
import neoforge.com.cursee.disenchanting_table.platform.Services;

public class DisEnchantingTableServer {
    public static boolean automatic_disenchanting = false;
    public static int automatic_disenchanting_ticks = 10;
    public static boolean resets_repair_cost = true;
    public static boolean requires_experience = true;
    public static boolean uses_points = true;
    public static int experience_cost = 25;

    public static void init() {
        DisEnchantingTableServer.createOrLoadConfiguration();
    }

    private static void createOrLoadConfiguration() {
        String configFilename;
        String configFileString;
        File configFile;
        String configDirectoryString = Services.PLATFORM.getGameDirectory() + File.separator + "config";
        File configDirectory = new File(configDirectoryString);
        if (!configDirectory.exists() && !configDirectory.mkdirs()) {
            Constants.LOG.info("Insufficient privileges to create directory {}", (Object)configDirectoryString);
            DisEnchantingTableServer.retainsDefaultsMessage();
        }
        if (!(configFile = new File(configFileString = configDirectoryString + File.separator + (configFilename = "disenchanting_table-server.toml"))).exists()) {
            InputStream ioStream = DisEnchantingTable.class.getClassLoader().getResourceAsStream("assets/" + configFilename);
            if (ioStream == null) {
                Constants.LOG.info("Unable to get resource from self {}", (Object)configFilename);
                DisEnchantingTableServer.retainsDefaultsMessage();
            }
            try (InputStream inputStream = ioStream;
                 BufferedInputStream bis = new BufferedInputStream(inputStream);
                 BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(configFile));){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = bis.read(buffer)) != -1) {
                    bos.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                Constants.LOG.info("Failed to copy default config file, error: {}", (Object)e.getMessage());
                DisEnchantingTableServer.retainsDefaultsMessage();
            }
        } else {
            Toml toml = new Toml().read(configFile);
            automatic_disenchanting = toml.getBoolean("automatic_disenchanting", Boolean.valueOf(automatic_disenchanting));
            automatic_disenchanting_ticks = Math.toIntExact(toml.getLong("automatic_disenchanting_ticks", Long.valueOf(automatic_disenchanting_ticks)));
            resets_repair_cost = toml.getBoolean("resets_repair_cost", Boolean.valueOf(resets_repair_cost));
            requires_experience = toml.getBoolean("requires_experience", Boolean.valueOf(requires_experience));
            uses_points = toml.getBoolean("uses_points", Boolean.valueOf(uses_points));
            experience_cost = Math.toIntExact(toml.getLong("experience_cost", Long.valueOf(experience_cost)));
        }
    }

    public static void retainsDefaultsMessage() {
        Constants.LOG.info("Configuration will retain default values.");
    }
}

