/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.disenchanting_table.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import neoforge.com.cursee.disenchanting_table.DisEnchantingTableClient;
import neoforge.com.cursee.disenchanting_table.DisEnchantingTableServer;
import neoforge.com.cursee.disenchanting_table.core.world.block.entity.DisEnchantingTableBlockEntity;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class DisEnchantingTableRenderer
implements BlockEntityRenderer<DisEnchantingTableBlockEntity> {
    private static final ItemStack MANUAL_STACK = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
    private final ItemRenderer renderer;

    public DisEnchantingTableRenderer(BlockEntityRendererProvider.Context context) {
        this.renderer = context.getItemRenderer();
    }

    private static int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.getBrightness(LightLayer.BLOCK, pos);
        int sLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }

    public void render(DisEnchantingTableBlockEntity table, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay, Vec3 vec3) {
        if (!DisEnchantingTableClient.render_table_item) {
            return;
        }
        if (table.getLevel() == null) {
            return;
        }
        ItemStack itemStack = table.getRenderedItemStack();
        if (!DisEnchantingTableServer.automatic_disenchanting) {
            itemStack = MANUAL_STACK;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.75f, 0.5f);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        Direction facing = (Direction)table.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(facing != Direction.EAST && facing != Direction.WEST ? facing.getOpposite().toYRot() : facing.toYRot()));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        this.renderer.renderStatic(itemStack, ItemDisplayContext.FIXED, DisEnchantingTableRenderer.getLightLevel(table.getLevel(), table.getBlockPos()), OverlayTexture.NO_OVERLAY, poseStack, multiBufferSource, table.getLevel(), 1);
        poseStack.popPose();
    }

    public boolean shouldRender(DisEnchantingTableBlockEntity blockEntity, Vec3 cameraPos) {
        return true;
    }
}

