/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.sleepingbags.items;

import com.mojang.datafixers.util.Either;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class ItemSleepingBag
extends Item {
    protected DyeColor dyeColor;

    public ItemSleepingBag(DyeColor dyeColor, Item.Properties properties) {
        super(properties.stacksTo(1));
        this.dyeColor = dyeColor;
    }

    public InteractionResult use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (worldIn.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (!BedBlock.canSetSpawn((Level)worldIn)) {
            playerIn.displayClientMessage((Component)Component.translatable((String)"message.sleeping_bags.cant_sleep_here"), true);
            return InteractionResult.SUCCESS;
        }
        if (!playerIn.onGround()) {
            playerIn.displayClientMessage((Component)Component.translatable((String)"message.sleeping_bags.cant_sleep_in_air"), true);
            return InteractionResult.SUCCESS;
        }
        this.trySleep((ServerPlayer)playerIn).ifLeft(sleepResult -> {
            if (sleepResult != null && sleepResult.getMessage() != null) {
                playerIn.displayClientMessage(sleepResult.getMessage(), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    public Either<Player.BedSleepingProblem, Unit> trySleep(ServerPlayer player) {
        Either ret = EventHooks.canPlayerStartSleeping((ServerPlayer)player, (BlockPos)player.blockPosition(), (Either)Either.right((Object)Unit.INSTANCE));
        if (ret.left().isPresent()) {
            return ret;
        }
        if (player.isSleeping() || !player.isAlive()) {
            return Either.left((Object)Player.BedSleepingProblem.OTHER_PROBLEM);
        }
        if (!player.level().dimensionType().natural()) {
            return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_HERE);
        }
        if (player.level().isBrightOutside()) {
            return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
        }
        if (!player.isCreative()) {
            Vec3 vector3d = player.position();
            List list = player.level().getEntitiesOfClass(Monster.class, new AABB(vector3d.x() - 8.0, vector3d.y() - 5.0, vector3d.z() - 8.0, vector3d.x() + 8.0, vector3d.y() + 5.0, vector3d.z() + 8.0), entity -> entity.isPreventingPlayerRest(player.level(), (Player)player));
            if (!list.isEmpty()) {
                return Either.left((Object)Player.BedSleepingProblem.NOT_SAFE);
            }
        }
        player.resetStat(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST));
        if (player.isPassenger()) {
            player.stopRiding();
        }
        player.setPose(Pose.SLEEPING);
        player.setSleepingPos(player.blockPosition());
        player.setDeltaMovement(Vec3.ZERO);
        player.hasImpulse = true;
        player.sleepCounter = 0;
        player.awardStat(Stats.SLEEP_IN_BED);
        CriteriaTriggers.SLEPT_IN_BED.trigger(player);
        player.level().updateSleepingPlayerList();
        return Either.right((Object)Unit.INSTANCE);
    }
}

