/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.belt;

import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.belt.IItemInBelt;
import dev.gigaherz.toolbelt.common.Screens;
import dev.gigaherz.toolbelt.slot.BeltAttachment;
import dev.gigaherz.toolbelt.slot.IBeltSlotItem;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolBeltItem
extends Item
implements IBeltSlotItem {
    public static void register(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, context) -> ToolBeltItem.getComponentItemHandler(stack), new ItemLike[]{ToolBelt.BELT});
        event.registerItem(IBeltSlotItem.CAPABILITY, (stack, context) -> (IBeltSlotItem)stack.getItem(), new ItemLike[]{ToolBelt.BELT});
    }

    @NotNull
    public static ComponentItemHandler getComponentItemHandler(ItemStack stack) {
        Integer size = (Integer)stack.get(ToolBelt.BELT_SIZE);
        return new ComponentItemHandler((MutableDataComponentHolder)stack, DataComponents.CONTAINER, size != null ? size : 2);
    }

    private static int getSlotFor(Inventory inv, ItemStack stack) {
        if (inv.getSelectedItem() == stack) {
            return inv.getSelectedSlot();
        }
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack invStack = inv.getItem(i);
            if (invStack != stack) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack of(int level) {
        return ((ToolBeltItem)ToolBelt.BELT.get()).forSize(level);
    }

    public ItemStack forSize(int size) {
        return ToolBeltItem.setSlotsCount(new ItemStack((ItemLike)this), Math.clamp((long)size, 2, 9));
    }

    public static int getSlotsCount(ItemStack stack) {
        Integer actualSize = (Integer)stack.get(ToolBelt.BELT_SIZE);
        return Math.clamp((long)Objects.requireNonNullElse(actualSize, 2).intValue(), 2, 9);
    }

    public static ItemStack setSlotsCount(ItemStack stack, int newSize) {
        int oldSize;
        Integer oldCount = (Integer)stack.get(ToolBelt.BELT_SIZE);
        int n = oldSize = oldCount != null ? oldCount : 2;
        if (newSize != oldSize) {
            ItemContainerContents oldInv = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
            if (oldInv != null) {
                ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
                int fill = Math.min(oldInv.getSlots(), Math.min(oldSize, newSize));
                for (int i = 0; i < fill; ++i) {
                    newItems.add(oldInv.getStackInSlot(i));
                }
                ItemContainerContents newInv = ItemContainerContents.fromItems(newItems);
                stack.set(DataComponents.CONTAINER, (Object)newInv);
            }
            stack.set(ToolBelt.BELT_SIZE, (Object)newSize);
        }
        return stack;
    }

    public ToolBeltItem(Item.Properties properties) {
        super(properties);
    }

    private InteractionResult openBeltScreen(@javax.annotation.Nullable Player player, ItemStack stack, Level world) {
        int slot;
        int n = slot = player != null ? ToolBeltItem.getSlotFor(player.getInventory(), stack) : -1;
        if (slot == -1) {
            return InteractionResult.FAIL;
        }
        if (!world.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Screens.openBeltScreen(serverPlayer, slot);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getHand() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        return this.openBeltScreen(context.getPlayer(), context.getItemInHand(), context.getLevel());
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        return this.openBeltScreen(player, stack, world);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> consumer, TooltipFlag advanced) {
        int size = ToolBeltItem.getSlotsCount(stack);
        consumer.accept((Component)Component.translatable((String)"text.toolbelt.tooltip", (Object[])new Object[]{size - 2, size}));
    }

    @Override
    public void onWornTick(ItemStack itemstack, BeltAttachment slot) {
        this.tickAllSlots(itemstack);
    }

    public void inventoryTick(ItemStack stack, ServerLevel p_401805_, Entity entity, @Nullable EquipmentSlot slot) {
        this.tickAllSlots(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }

    public static ItemStack makeUpgradedStack(ItemStack stack) {
        int slots = ToolBeltItem.getSlotsCount(stack);
        if (slots >= 9) {
            return stack.copy();
        }
        stack = stack.copy();
        ToolBeltItem.setSlotsCount(stack, slots + 1);
        return stack;
    }

    private void tickAllSlots(ItemStack source) {
        IItemHandler inventory = Objects.requireNonNull((IItemHandler)source.getCapability(Capabilities.ItemHandler.ITEM), "No inventory!");
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.isEmpty()) {
                return;
            }
            IItemInBelt extItem = (IItemInBelt)stack.getCapability(IItemInBelt.CAPABILITY);
            if (extItem == null) continue;
            extItem.onWornTick(stack, source);
        }
    }
}

