/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.client;

import com.mojang.blaze3d.platform.InputConstants;
import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.client.HasCustomColor;
import dev.gigaherz.toolbelt.client.RadialMenuScreen;
import dev.gigaherz.toolbelt.client.ToolBeltLayer;
import dev.gigaherz.toolbelt.network.OpenBeltSlotInventory;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.ClientInput;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RegisterConditionalItemModelPropertyEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

@Mod(value="toolbelt", dist={Dist.CLIENT})
public class ToolBeltClient {
    @Nullable
    public static KeyMapping OPEN_TOOL_MENU_KEYBIND;
    @Nullable
    public static KeyMapping CYCLE_TOOL_MENU_LEFT_KEYBIND;
    @Nullable
    public static KeyMapping CYCLE_TOOL_MENU_RIGHT_KEYBIND;
    public static KeyMapping OPEN_BELT_SLOT_KEYBIND;
    private boolean toolMenuKeyWasDown = false;
    public static ModelLayerLocation BELT_LAYER;
    public static ModelLayerLocation BUCKLE_LAYER;

    public ToolBeltClient(ModContainer container, IEventBus modEventBus) {
        modEventBus.addListener(this::initKeybinds);
        modEventBus.addListener(this::registerModelProperties);
        modEventBus.addListener(this::registerLayer);
        modEventBus.addListener(this::addLayers);
        NeoForge.EVENT_BUS.addListener(this::handleKeys);
        NeoForge.EVENT_BUS.addListener(this::updateInputEvent);
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    public void registerModelProperties(RegisterConditionalItemModelPropertyEvent event) {
        event.register(ToolBelt.location("has_custom_color"), HasCustomColor.CODEC);
    }

    public void initKeybinds(RegisterKeyMappingsEvent event) {
        OPEN_TOOL_MENU_KEYBIND = new KeyMapping("key.toolbelt.open", 82, "key.toolbelt.category");
        event.register(OPEN_TOOL_MENU_KEYBIND);
        CYCLE_TOOL_MENU_LEFT_KEYBIND = new KeyMapping("key.toolbelt.cycle.left", InputConstants.UNKNOWN.getValue(), "key.toolbelt.category");
        event.register(CYCLE_TOOL_MENU_LEFT_KEYBIND);
        CYCLE_TOOL_MENU_RIGHT_KEYBIND = new KeyMapping("key.toolbelt.cycle.right", InputConstants.UNKNOWN.getValue(), "key.toolbelt.category");
        event.register(CYCLE_TOOL_MENU_RIGHT_KEYBIND);
        OPEN_BELT_SLOT_KEYBIND = new KeyMapping("key.toolbelt.slot", 86, "key.toolbelt.category");
        event.register(OPEN_BELT_SLOT_KEYBIND);
    }

    public void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BELT_LAYER, ToolBeltLayer.BeltModel::createBodyLayer);
        event.registerLayerDefinition(BUCKLE_LAYER, ToolBeltLayer.BeltModel::createBuckleLayer);
    }

    public void addLayers(EntityRenderersEvent.AddLayers event) {
        ToolBeltClient.addLayerToHumanoid(event, EntityType.ARMOR_STAND, ToolBeltLayer::new);
        ToolBeltClient.addLayerToHumanoid(event, EntityType.ZOMBIE, ToolBeltLayer::new);
        ToolBeltClient.addLayerToHumanoid(event, EntityType.SKELETON, ToolBeltLayer::new);
        ToolBeltClient.addLayerToHumanoid(event, EntityType.HUSK, ToolBeltLayer::new);
        ToolBeltClient.addLayerToHumanoid(event, EntityType.DROWNED, ToolBeltLayer::new);
        ToolBeltClient.addLayerToHumanoid(event, EntityType.STRAY, ToolBeltLayer::new);
        ToolBeltClient.addLayerToPlayerSkin(event, PlayerSkin.Model.WIDE, ToolBeltLayer::new);
        ToolBeltClient.addLayerToPlayerSkin(event, PlayerSkin.Model.SLIM, ToolBeltLayer::new);
    }

    private static <E extends Player, S extends HumanoidRenderState, M extends HumanoidModel<S>> void addLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, PlayerSkin.Model skinName, Function<LivingEntityRenderer<E, S, M>, ? extends RenderLayer<S, M>> factory) {
        EntityRenderer renderer = event.getSkin(skinName);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer ler = (LivingEntityRenderer)renderer;
            ler.addLayer(factory.apply(ler));
        }
    }

    private static <E extends LivingEntity, S extends HumanoidRenderState, M extends HumanoidModel<S>> void addLayerToHumanoid(EntityRenderersEvent.AddLayers event, EntityType<E> entityType, Function<LivingEntityRenderer<E, S, M>, ? extends RenderLayer<S, M>> factory) {
        EntityRenderer renderer = event.getRenderer(entityType);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer ler = (LivingEntityRenderer)renderer;
            ler.addLayer(factory.apply(ler));
        }
    }

    public static void wipeOpen() {
        while (OPEN_TOOL_MENU_KEYBIND != null && OPEN_TOOL_MENU_KEYBIND.consumeClick()) {
        }
    }

    public void handleKeys(ClientTickEvent.Pre ev) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen == null) {
            boolean toolMenuKeyIsDown;
            boolean bl = toolMenuKeyIsDown = OPEN_TOOL_MENU_KEYBIND != null && OPEN_TOOL_MENU_KEYBIND.isDown();
            if (toolMenuKeyIsDown && !this.toolMenuKeyWasDown) {
                while (OPEN_TOOL_MENU_KEYBIND != null && OPEN_TOOL_MENU_KEYBIND.consumeClick()) {
                    ItemStack inHand;
                    if (mc.screen != null || !ConfigData.isItemStackAllowed(inHand = mc.player.getMainHandItem())) continue;
                    BeltFinder.findBelt((LivingEntity)mc.player).ifPresent(getter -> mc.setScreen((Screen)new RadialMenuScreen((BeltFinder.BeltGetter)getter)));
                }
            }
            this.toolMenuKeyWasDown = toolMenuKeyIsDown;
        } else {
            this.toolMenuKeyWasDown = true;
        }
        if (ConfigData.customBeltSlotEnabled) {
            while (OPEN_BELT_SLOT_KEYBIND != null && OPEN_BELT_SLOT_KEYBIND.consumeClick()) {
                if (mc.screen != null) continue;
                ClientPacketDistributor.sendToServer((CustomPacketPayload)OpenBeltSlotInventory.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void updateInputEvent(MovementInputUpdateEvent event) {
        if (Minecraft.getInstance().screen instanceof RadialMenuScreen) {
            Options settings = Minecraft.getInstance().options;
            ClientInput eInput = event.getInput();
            eInput.keyPresses = new Input(ToolBeltClient.isKeyDown0(settings.keyUp), ToolBeltClient.isKeyDown0(settings.keyDown), ToolBeltClient.isKeyDown0(settings.keyLeft), ToolBeltClient.isKeyDown0(settings.keyRight), ToolBeltClient.isKeyDown0(settings.keyJump), ToolBeltClient.isKeyDown0(settings.keyShift), ToolBeltClient.isKeyDown0(settings.keySprint));
            eInput.moveVector = new Vec2(eInput.keyPresses.left() == eInput.keyPresses.right() ? 0.0f : (eInput.keyPresses.left() ? 1.0f : -1.0f), eInput.keyPresses.forward() == eInput.keyPresses.backward() ? 0.0f : (eInput.keyPresses.forward() ? 1.0f : -1.0f));
            if (Minecraft.getInstance().player.isMovingSlowly()) {
                eInput.moveVector = new Vec2((float)((double)eInput.moveVector.x * 0.3), (float)((double)eInput.moveVector.y * 0.3));
            }
        }
    }

    public static boolean isKeyDown0(KeyMapping keybind) {
        if (keybind.isUnbound()) {
            return false;
        }
        return switch (keybind.getKey().getType()) {
            case InputConstants.Type.KEYSYM -> InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keybind.getKey().getValue());
            case InputConstants.Type.MOUSE -> {
                if (GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)keybind.getKey().getValue()) == 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static boolean isKeyDown(KeyMapping keybind) {
        if (keybind.isUnbound()) {
            return false;
        }
        boolean isDown = switch (keybind.getKey().getType()) {
            case InputConstants.Type.KEYSYM -> InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keybind.getKey().getValue());
            case InputConstants.Type.MOUSE -> {
                if (GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)keybind.getKey().getValue()) == 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
        return isDown && keybind.getKeyConflictContext().isActive() && keybind.getKeyModifier().isActive(keybind.getKeyConflictContext());
    }

    static {
        BELT_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"player"), "toolbelt_belt");
        BUCKLE_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"player"), "toolbelt_belt_buckle");
    }
}

