/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.client.EntityRenderStateToolBeltContext;
import dev.gigaherz.toolbelt.client.ToolBeltClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.joml.Quaternionfc;

public class ToolBeltLayer<S extends HumanoidRenderState, M extends HumanoidModel<? super S>>
extends RenderLayer<S, M> {
    private static final ResourceLocation TEXTURE_BELT = ToolBelt.location("textures/entity/belt.png");
    private static final ResourceLocation TEXTURE_BELT_DYED = ToolBelt.location("textures/entity/dyed_belt.png");
    private static ItemDisplayContext LEFTSIDE = Enum.valueOf(ItemDisplayContext.class, "TOOLBELT_LEFTSIDE");
    private static ItemDisplayContext RIGHTSIDE = Enum.valueOf(ItemDisplayContext.class, "TOOLBELT_RIGHTSIDE");
    private final EntityModel<S> beltModel = new BeltModel(this, Minecraft.getInstance().getEntityModels().bakeLayer(ToolBeltClient.BELT_LAYER));
    private final EntityModel<S> buckleModel = new BeltModel(this, Minecraft.getInstance().getEntityModels().bakeLayer(ToolBeltClient.BUCKLE_LAYER));

    public ToolBeltLayer(RenderLayerParent<S, M> owner) {
        super(owner);
    }

    private void translateToBody(S renderState, PoseStack poseStack) {
        ((HumanoidModel)this.getParentModel()).body.translateAndRotate(poseStack);
        if (((HumanoidRenderState)renderState).isBaby) {
            poseStack.scale(0.52f, 0.52f, 0.52f);
            poseStack.translate(0.0, 1.4, 0.0);
        }
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int lightness, S renderState, float v, float v1) {
        if (!ConfigData.showBeltOnPlayers) {
            return;
        }
        if (!(renderState instanceof EntityRenderStateToolBeltContext)) {
            return;
        }
        EntityRenderStateToolBeltContext beltState = (EntityRenderStateToolBeltContext)renderState;
        BeltFinder.BeltGetter getter = beltState.toolbelt_getBelt();
        if (getter == null || getter.isHidden()) {
            return;
        }
        ItemStack stack = getter.getBelt();
        poseStack.pushPose();
        this.translateToBody(renderState, poseStack);
        IItemHandler cap = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (cap != null) {
            ItemStack rightItem;
            boolean rightHanded = ((HumanoidRenderState)renderState).attackArm == HumanoidArm.RIGHT;
            ItemStack firstItem = cap.getStackInSlot(0);
            ItemStack secondItem = cap.getStackInSlot(1);
            ItemStack leftItem = rightHanded ? firstItem : secondItem;
            ItemStack itemStack = rightItem = rightHanded ? secondItem : firstItem;
            if (!leftItem.isEmpty() || !rightItem.isEmpty()) {
                poseStack.pushPose();
                if (((HumanoidRenderState)renderState).isBaby) {
                    poseStack.translate(0.0f, 0.75f, 0.0f);
                    poseStack.scale(0.5f, 0.5f, 0.5f);
                }
                ToolBeltLayer.renderHeldItem(rightItem, RIGHTSIDE, false, poseStack, buffer, lightness);
                ToolBeltLayer.renderHeldItem(leftItem, LEFTSIDE, true, poseStack, buffer, lightness);
                poseStack.popPose();
            }
        }
        poseStack.translate(0.0f, 0.19f, 0.0f);
        poseStack.scale(0.85f, 0.6f, 0.78f);
        DyedItemColor dyeInfo = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
        int dyeColor = dyeInfo != null ? 0xFF000000 | dyeInfo.rgb() : -1;
        ToolBeltLayer.renderColoredCutoutModel(this.beltModel, (ResourceLocation)this.getTextureLocation(stack), (PoseStack)poseStack, (MultiBufferSource)buffer, (int)lightness, renderState, (int)dyeColor);
        ToolBeltLayer.renderColoredCutoutModel(this.buckleModel, (ResourceLocation)TEXTURE_BELT, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)lightness, renderState, (int)-1);
        poseStack.popPose();
    }

    private static void renderHeldItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int lightmapCoords) {
        if (stack.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        if (leftHand) {
            poseStack.translate(-0.271875f, 0.7f, -0.1f);
        } else {
            poseStack.translate(0.271875f, 0.7f, -0.1f);
        }
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(40.0f));
        float scale = ConfigData.beltItemScale;
        poseStack.scale(scale, scale, scale);
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, transformType, lightmapCoords, OverlayTexture.NO_OVERLAY, poseStack, buffer, (Level)Minecraft.getInstance().level, 42);
        poseStack.popPose();
    }

    protected ResourceLocation getTextureLocation(ItemStack stack) {
        return stack.isEmpty() ? TEXTURE_BELT : (stack.has(DataComponents.DYED_COLOR) ? TEXTURE_BELT_DYED : TEXTURE_BELT);
    }

    public class BeltModel
    extends EntityModel<S> {
        private static final String BELT = "belt";
        private static final String BUCKLE = "buckle";
        private static final String LEFT_POCKET = "left_pocket";
        private static final String RIGHT_POCKET = "right_pocket";

        protected BeltModel(ToolBeltLayer this$0, ModelPart root) {
            super(root);
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.getRoot();
            partdefinition.addOrReplaceChild(BELT, CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 10.0f, -3.0f, 10.0f, 4.0f, 6.0f), PartPose.ZERO);
            partdefinition.addOrReplaceChild(LEFT_POCKET, CubeListBuilder.create().texOffs(0, 10).addBox(-2.0f, 12.0f, 5.0f, 4.0f, 4.0f, 1.0f), PartPose.rotation((float)0.0f, (float)-90.0f, (float)0.0f));
            partdefinition.addOrReplaceChild(RIGHT_POCKET, CubeListBuilder.create().texOffs(0, 10).addBox(-2.0f, 12.0f, 5.0f, 4.0f, 4.0f, 1.0f), PartPose.rotation((float)0.0f, (float)90.0f, (float)0.0f));
            return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
        }

        public static LayerDefinition createBuckleLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.getRoot();
            partdefinition.addOrReplaceChild(BUCKLE, CubeListBuilder.create().texOffs(10, 10).addBox(-2.5f, 9.5f, -3.5f, 5.0f, 5.0f, 1.0f), PartPose.ZERO);
            return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
        }
    }
}

