/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.common;

import dev.gigaherz.toolbelt.ConfigData;
import java.util.Objects;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BeltSlot
extends Slot {
    public BeltSlot(final Container playerInventory, final ItemStack heldItem, final int blockedSlot, final int index, int xPosition, int yPosition) {
        super(new Container(){
            final Container sourceInventory;
            final int slot;
            final int subSlot;
            final ItemStack fallbackItem;
            ItemStack beltStack;
            IItemHandlerModifiable inventory;
            {
                this.sourceInventory = playerInventory;
                this.slot = blockedSlot;
                this.subSlot = index;
                this.fallbackItem = heldItem;
                this.beltStack = null;
                this.inventory = null;
            }

            IItemHandlerModifiable findStack() {
                ItemStack stack;
                ItemStack itemStack = stack = this.slot >= 0 ? this.sourceInventory.getItem(this.slot) : this.fallbackItem;
                if (stack != this.beltStack) {
                    this.beltStack = stack;
                    this.inventory = (IItemHandlerModifiable)Objects.requireNonNullElse((IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM), new ItemStackHandler(9));
                }
                return this.inventory;
            }

            public int getContainerSize() {
                return 1;
            }

            public boolean isEmpty() {
                return this.getItem(0).getCount() <= 0;
            }

            public ItemStack getItem(int n) {
                return this.findStack().getStackInSlot(this.subSlot);
            }

            public ItemStack removeItem(int n, int count) {
                return this.findStack().extractItem(this.subSlot, count, false);
            }

            public ItemStack removeItemNoUpdate(int n) {
                ItemStack existing = this.getItem(0);
                this.setItem(n, ItemStack.EMPTY);
                return existing;
            }

            public void setItem(int n, ItemStack stack) {
                this.findStack().setStackInSlot(this.subSlot, stack);
            }

            public int getMaxStackSize() {
                return this.findStack().getSlotLimit(this.subSlot);
            }

            public void setChanged() {
            }

            public boolean stillValid(Player player) {
                return false;
            }

            public void startOpen(Player player) {
            }

            public void stopOpen(Player player) {
            }

            public boolean canPlaceItem(int index2, ItemStack stack) {
                return ConfigData.isItemStackAllowed(stack);
            }

            public void clearContent() {
            }
        }, blockedSlot, xPosition, yPosition);
    }

    public boolean mayPlace(ItemStack stack) {
        return ConfigData.isItemStackAllowed(stack);
    }
}

