/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.slot;

import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.network.ContainerSlotsHack;
import dev.gigaherz.toolbelt.slot.BeltAttachment;
import dev.gigaherz.toolbelt.slot.BeltSlot;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AbstractCraftingMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class BeltSlotMenu
extends AbstractCraftingMenu {
    private final BeltSlot slotBelt;
    private final Player owner;

    public BeltSlotMenu(int id, Inventory playerInventory) {
        super((MenuType)ToolBelt.BELT_SLOT_MENU.get(), id, 2, 2);
        this.owner = playerInventory.player;
        this.addResultSlot(this.owner, 154, 28);
        this.addCraftingGridSlots(98, 18);
        for (int i = 0; i < 4; ++i) {
            EquipmentSlot equipmentslot = InventoryMenu.SLOT_IDS[i];
            ResourceLocation resourcelocation = (ResourceLocation)InventoryMenu.TEXTURE_EMPTY_SLOTS.get(equipmentslot);
            this.addSlot((Slot)new ArmorSlot((Container)playerInventory, (LivingEntity)this.owner, equipmentslot, 39 - i, 8, 8 + i * 18, resourcelocation));
        }
        this.addStandardInventorySlots((Container)playerInventory, 8, 84);
        this.addSlot(new Slot((Container)playerInventory, 40, 77, 62){

            public void setByPlayer(ItemStack p_270969_, ItemStack p_299918_) {
                BeltSlotMenu.this.owner.onEquipItem(EquipmentSlot.OFFHAND, p_299918_, p_270969_);
                super.setByPlayer(p_270969_, p_299918_);
            }

            public ResourceLocation getNoItemIcon() {
                return InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD;
            }
        });
        this.slotBelt = new BeltSlot(BeltAttachment.get((LivingEntity)playerInventory.player), 77, 44);
        this.addSlot(this.slotBelt);
        if (playerInventory.player.level().isClientSide) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)ContainerSlotsHack.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void slotsChanged(Container inventory) {
        Level level = this.owner.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Bridge.slotChangedCraftingGridAccessor((AbstractContainerMenu)this, serverLevel, this.owner, this.craftSlots, this.resultSlots, null);
        }
    }

    public void removed(Player player) {
        super.removed(player);
        this.resultSlots.clearContent();
        if (!player.level().isClientSide) {
            this.clearContainer(player, (Container)this.craftSlots);
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack remaining = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            int i;
            ItemStack slotContents = slot.getItem();
            remaining = slotContents.copy();
            EquipmentSlot equipmentslot = player.getEquipmentSlotForItem(remaining);
            if (index == this.slotBelt.index) {
                if (!this.moveItemStackTo(slotContents, 9, 45, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (index == 0) {
                if (!this.moveItemStackTo(slotContents, 9, 45, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotContents, remaining);
            } else if (index >= 1 && index < 5 ? !this.moveItemStackTo(slotContents, 9, 45, false) : (index >= 5 && index < 9 ? !this.moveItemStackTo(slotContents, 9, 45, false) : (equipmentslot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR && !((Slot)this.slots.get(8 - equipmentslot.getIndex())).hasItem() ? !this.moveItemStackTo(slotContents, i = 8 - equipmentslot.getIndex(), i + 1, false) : (equipmentslot == EquipmentSlot.OFFHAND && !((Slot)this.slots.get(45)).hasItem() ? !this.moveItemStackTo(slotContents, 45, 46, false) : (this.slotBelt.mayPlace(slotContents) && !this.slotBelt.hasItem() ? !this.moveItemStackTo(slotContents, this.slotBelt.index, this.slotBelt.index + 1, false) : (index >= 9 && index < 36 ? !this.moveItemStackTo(slotContents, 36, 45, false) : (index >= 36 && index < 45 ? !this.moveItemStackTo(slotContents, 9, 36, false) : !this.moveItemStackTo(slotContents, 9, 45, false)))))))) {
                return ItemStack.EMPTY;
            }
            if (slotContents.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY, remaining);
            } else {
                slot.setChanged();
            }
            if (slotContents.getCount() == remaining.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotContents);
            if (index == 0) {
                player.drop(slotContents, false);
            }
        }
        return remaining;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.resultSlots && super.canTakeItemForPickAll(stack, slot);
    }

    public Slot getResultSlot() {
        return (Slot)this.slots.get(0);
    }

    public List<Slot> getInputGridSlots() {
        return this.slots.subList(1, 5);
    }

    public CraftingContainer getCraftSlots() {
        return this.craftSlots;
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    protected Player owner() {
        return this.owner;
    }

    private static class Bridge
    extends CraftingMenu {
        private Bridge(int pContainerId, Inventory pPlayerInventory) {
            super(pContainerId, pPlayerInventory);
            throw new IllegalStateException("Not instantiable.");
        }

        public static void slotChangedCraftingGridAccessor(AbstractContainerMenu container, ServerLevel level, Player player, CraftingContainer craftingInventory, ResultContainer craftResultInventory, RecipeHolder<CraftingRecipe> recipeHolder) {
            CraftingMenu.slotChangedCraftingGrid((AbstractContainerMenu)container, (ServerLevel)level, (Player)player, (CraftingContainer)craftingInventory, (ResultContainer)craftResultInventory, recipeHolder);
        }
    }
}

