/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.slot;

import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.slot.BeltSlotMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.client.gui.screens.inventory.EffectsInInventory;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.CraftingRecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractCraftingMenu;
import net.minecraft.world.inventory.RecipeBookMenu;

public class BeltSlotScreen
extends AbstractRecipeBookScreen<BeltSlotMenu> {
    private static final ResourceLocation SCREEN_BACKGROUND = ToolBelt.location("textures/gui/belt_slot.png");
    private float oldMouseX;
    private float oldMouseY;
    private boolean buttonClicked;
    private final EffectsInInventory effects;

    public BeltSlotScreen(BeltSlotMenu container, Inventory playerInventory, Component title) {
        super((RecipeBookMenu)container, (RecipeBookComponent)new CraftingRecipeBookComponent((AbstractCraftingMenu)container), playerInventory, title);
        this.titleLabelX = 97;
        this.effects = new EffectsInInventory((AbstractContainerScreen)this);
    }

    public void containerTick() {
        super.containerTick();
    }

    protected void init() {
        super.init();
    }

    protected ScreenPosition getRecipeBookButtonPosition() {
        return new ScreenPosition(this.leftPos + 104, this.height / 2 - 22);
    }

    protected void onRecipeBookButtonClick() {
        this.buttonClicked = true;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.effects.renderEffects(guiGraphics, mouseX, mouseY);
        this.effects.renderTooltip(guiGraphics, mouseX, mouseY);
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
    }

    public boolean showsActiveEffects() {
        return this.effects.canSeeEffects();
    }

    protected boolean isBiggerResultSlot() {
        return false;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, SCREEN_BACKGROUND, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(i + 26), (int)(j + 8), (int)(i + 75), (int)(j + 78), (int)30, (float)0.0625f, (float)this.oldMouseX, (float)this.oldMouseY, (LivingEntity)this.minecraft.player);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

