/*
 * Decompiled with CFR 0.152.
 */
package yourdailymodder.weaponmaster.setup.events_on_client;

import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import yourdailymodder.weaponmaster.itemlayers.HumanoidItemLayer;
import yourdailymodder.weaponmaster.renderer.quiver.QuiverWithArrowsModel;
import yourdailymodder.weaponmaster.setup.KeyHandler;

@EventBusSubscriber(modid="weaponmaster_ydm", value={Dist.CLIENT})
public class ClientOnlyModSetup {
    @SubscribeEvent
    public static void registerKeybinds(RegisterKeyMappingsEvent event) {
        event.register(KeyHandler.OPEN_SCREEN);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(QuiverWithArrowsModel.LAYER_LOCATION, QuiverWithArrowsModel::createBodyLayer);
        event.registerLayerDefinition(QuiverWithArrowsModel.ARROWS_LAYER_LOCATION, QuiverWithArrowsModel::createArrowBodyLayer);
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers evt) {
        evt.getSkins().forEach(s -> {
            EntityRenderer renderer = evt.getSkin(s);
            if (renderer instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
                livingRenderer.addLayer(new HumanoidItemLayer(livingRenderer));
            }
        });
    }
}

