/*
 * Decompiled with CFR 0.152.
 */
package yourdailymodder.weaponmaster.setup.helper;

import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.CommonHooks;
import yourdailymodder.weaponmaster.WeaponMasterMod;
import yourdailymodder.weaponmaster.setup.helper.ModUtils;
import yourdailymodder.weaponmaster.setup.networking.Networking;
import yourdailymodder.weaponmaster.setup.networking.client.blacklist.BlacklistCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.itemstack.ItemStackCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.positions.PositionsCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.rotations.RotationsCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.scale.ScaleCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.selectedslot.SelectedSlotCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.slotattachment.SlotAttachmentCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.slotmover.SlotMoverCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.toggle.ToggleCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.uniqueitemsettings.UniqueItemSettingsCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.whitelist.WhitelistCPacket;
import yourdailymodder.weaponmaster.setup.playerdata.IPlayerData;
import yourdailymodder.weaponmaster.setup.playerdata.PlayerData;

public class ServerHelper {
    public static ItemStack getProjectile(Player player, ItemStack p_36349_) {
        if (!(p_36349_.getItem() instanceof ProjectileWeaponItem)) {
            return ItemStack.EMPTY;
        }
        Predicate predicate = ((ProjectileWeaponItem)p_36349_.getItem()).getSupportedHeldProjectiles();
        ItemStack itemstack = ProjectileWeaponItem.getHeldProjectile((LivingEntity)player, (Predicate)predicate);
        if (!itemstack.isEmpty()) {
            return CommonHooks.getProjectile((LivingEntity)player, (ItemStack)p_36349_, (ItemStack)itemstack);
        }
        predicate = ((ProjectileWeaponItem)p_36349_.getItem()).getAllSupportedProjectiles();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack itemstack1 = player.getInventory().getItem(i);
            if (!predicate.test(itemstack1)) continue;
            return CommonHooks.getProjectile((LivingEntity)player, (ItemStack)p_36349_, (ItemStack)itemstack1);
        }
        return CommonHooks.getProjectile((LivingEntity)player, (ItemStack)p_36349_, (ItemStack)(player.getAbilities().instabuild ? new ItemStack((ItemLike)Items.ARROW) : ItemStack.EMPTY));
    }

    public static void sendAllDataToClient(Player target, ServerPlayer player) {
        PlayerData data = ((IPlayerData)target).getPlayerData();
        if (data != null) {
            if (data.positions != null) {
                Networking.sendToClient(new PositionsCPacket(ModUtils.intToString(data.positions), false, target.getStringUUID()), player);
            }
            if (data.rotations != null) {
                Networking.sendToClient(new RotationsCPacket(ModUtils.intToString(data.rotations), false, target.getStringUUID()), player);
            }
            if (data.scale != null) {
                Networking.sendToClient(new ScaleCPacket(ModUtils.intToByte(data.scale), false, target.getStringUUID()), player);
            }
            if (data.toggleSlots != null) {
                Networking.sendToClient(new ToggleCPacket(ModUtils.intToByte(data.toggleSlots), false, target.getStringUUID()), player);
            }
            for (int i = 0; i < WeaponMasterMod.maxDisplaySlotNum; ++i) {
                if (data.inventory[i] == null) continue;
                Networking.sendToClient(new ItemStackCPacket(Item.getId((Item)data.inventory[i].getItem()), i, target.getStringUUID()), player);
            }
            Networking.sendToClient(new SelectedSlotCPacket(data.selectedSlot, target.getStringUUID()), player);
            if (data.slotAttachments != null) {
                Networking.sendToClient(new SlotAttachmentCPacket(data.slotAttachments, false, target.getStringUUID()), player);
            }
            if (data.mover != null) {
                Networking.sendToClient(new SlotMoverCPacket(data.mover, false, target.getStringUUID()), player);
            }
            if (data.blacklist != null) {
                Networking.sendToClient(new BlacklistCPacket(data.blacklist, false, target.getStringUUID()), player);
            }
            if (data.whitelist != null) {
                Networking.sendToClient(new WhitelistCPacket(data.whitelist, false, target.getStringUUID()), player);
            }
            if (data.uniqueItemDisplay != null) {
                Networking.sendToClient(new UniqueItemSettingsCPacket(data.uniqueItemDisplay, false, target.getStringUUID()), player);
            }
        }
    }
}

