/*
 * Decompiled with CFR 0.152.
 */
package yourdailymodder.weaponmaster.setup.networking.client.sendhandshake;

import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import yourdailymodder.weaponmaster.WeaponMasterMod;
import yourdailymodder.weaponmaster.setup.configs.ConfigHolder;
import yourdailymodder.weaponmaster.setup.helper.ModUtils;
import yourdailymodder.weaponmaster.setup.helper.ServerHelper;
import yourdailymodder.weaponmaster.setup.networking.Networking;
import yourdailymodder.weaponmaster.setup.networking.client.sendhandshake.SendHandshakeCPacket;
import yourdailymodder.weaponmaster.setup.networking.server.blacklist.BlacklistSPacket;
import yourdailymodder.weaponmaster.setup.networking.server.itemstack.ItemStackSPacket;
import yourdailymodder.weaponmaster.setup.networking.server.positions.PositionsSPacket;
import yourdailymodder.weaponmaster.setup.networking.server.rotations.RotationsSPacket;
import yourdailymodder.weaponmaster.setup.networking.server.scale.ScaleSPacket;
import yourdailymodder.weaponmaster.setup.networking.server.selectedslot.SelectedSlotSPacket;
import yourdailymodder.weaponmaster.setup.networking.server.slotattachment.SlotAttachmentSPacket;
import yourdailymodder.weaponmaster.setup.networking.server.slotmover.SlotMoverSPacket;
import yourdailymodder.weaponmaster.setup.networking.server.toggle.ToggleSPacket;
import yourdailymodder.weaponmaster.setup.networking.server.uniqueitemsettings.UniqueItemSettingsSPacket;
import yourdailymodder.weaponmaster.setup.networking.server.whitelist.WhitelistSPacket;

public class ClientPayloadHandler {
    public static void handleData(SendHandshakeCPacket data, IPayloadContext context) {
        ClientPayloadHandler.playerChanged(data);
        context.enqueueWork(() -> ClientPayloadHandler.playerChanged(data)).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"weaponmaster_ydm.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void playerChanged(SendHandshakeCPacket packetdata) {
        assert (Minecraft.getInstance().level != null);
        for (Player sp : Minecraft.getInstance().level.players()) {
            if (!sp.getStringUUID().equals(packetdata.uuid())) continue;
            WeaponMasterMod.isMultiplayer = true;
            ItemStack[] inventory = new ItemStack[WeaponMasterMod.maxDisplaySlotNum];
            block1: for (int i = 0; i < WeaponMasterMod.maxDisplaySlotNum; ++i) {
                if (i == 9) {
                    inventory[i] = sp.getOffhandItem() == null ? new ItemStack((ItemLike)Items.AIR) : sp.getOffhandItem();
                    continue;
                }
                if (i == 10) {
                    inventory[i] = new ItemStack((ItemLike)Items.AIR);
                    for (int j = 0; j < 9; ++j) {
                        if (inventory[j] == null || !(inventory[j].getItem() instanceof ProjectileWeaponItem)) continue;
                        inventory[i] = ServerHelper.getProjectile(sp, inventory[j]);
                        continue block1;
                    }
                    continue;
                }
                inventory[i] = sp.getInventory().getItem(i) == null ? new ItemStack((ItemLike)Items.AIR) : sp.getInventory().getItem(i);
            }
            int hideTick = (Integer)ConfigHolder.COMMON.hideTick.get();
            int selectedSlot = sp.getInventory().getSelectedSlot();
            String slotAttachment = (String)ConfigHolder.COMMON.slot_attachment.get();
            String slotMover = (String)ConfigHolder.COMMON.slotMover.get();
            String blacklist = (String)ConfigHolder.COMMON.blacklist.get();
            String whitelist = (String)ConfigHolder.COMMON.whitelist.get();
            String uniqueItemSettings = (String)ConfigHolder.COMMON.uniqueItemDisplay.get();
            if (!WeaponMasterMod.isMultiplayer()) continue;
            Networking.sendToServer(new PositionsSPacket(ModUtils.intToString(ConfigHolder.COMMON.positions)));
            Networking.sendToServer(new RotationsSPacket(ModUtils.intToString(ConfigHolder.COMMON.rotations)));
            Networking.sendToServer(new ScaleSPacket(ModUtils.intToByte(ConfigHolder.COMMON.scale)));
            Networking.sendToServer(new ToggleSPacket(ModUtils.booleanToByte(ConfigHolder.COMMON.TOGGLE_SLOT_MODEL)));
            for (int i = 0; i < WeaponMasterMod.maxDisplaySlotNum; ++i) {
                Networking.sendToServer(new ItemStackSPacket(Item.getId((Item)inventory[i].getItem()), i));
            }
            Networking.sendToServer(new SelectedSlotSPacket(selectedSlot));
            Networking.sendToServer(new SlotAttachmentSPacket(slotAttachment));
            Networking.sendToServer(new SlotMoverSPacket(slotMover));
            Networking.sendToServer(new BlacklistSPacket(blacklist));
            Networking.sendToServer(new WhitelistSPacket(whitelist));
            Networking.sendToServer(new UniqueItemSettingsSPacket(uniqueItemSettings));
        }
    }
}

