/*
 * Decompiled with CFR 0.152.
 */
package yourdailymodder.weaponmaster.setup.networking.server.itemstack;

import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import yourdailymodder.weaponmaster.setup.networking.Networking;
import yourdailymodder.weaponmaster.setup.networking.client.itemstack.ItemStackCPacket;
import yourdailymodder.weaponmaster.setup.networking.server.itemstack.ItemStackSPacket;
import yourdailymodder.weaponmaster.setup.playerdata.IPlayerData;
import yourdailymodder.weaponmaster.setup.playerdata.PlayerData;

public class ServerPayloadHandler {
    public static void handleData(ItemStackSPacket data, IPayloadContext context) {
        ServerPayloadHandler.playerChanged(data, context.player());
        context.enqueueWork(() -> ServerPayloadHandler.playerChanged(data, context.player())).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"weaponmaster_ydm.networking.failed.server", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void playerChanged(ItemStackSPacket packetdata, Player sender) {
        assert (sender.level() != null);
        if (!sender.level().isClientSide()) {
            PlayerData data = ((IPlayerData)sender).getPlayerData();
            ItemStack value = new ItemStack((ItemLike)Item.byId((int)packetdata.itemID()));
            if (data != null && value != null) {
                data.inventory[packetdata.slot()] = value;
                for (Player sp : sender.level().players()) {
                    Networking.sendToClient(new ItemStackCPacket(packetdata.itemID(), packetdata.slot(), sender.getStringUUID()), (ServerPlayer)sp);
                }
            }
        }
    }
}

