/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.config.proxy;

import fr.rakambda.fallingtree.common.config.IConfiguration;
import fr.rakambda.fallingtree.common.config.IEnchantmentConfiguration;
import fr.rakambda.fallingtree.common.config.IPlayerConfiguration;
import fr.rakambda.fallingtree.common.config.IResettable;
import fr.rakambda.fallingtree.common.config.enums.NotificationMode;
import fr.rakambda.fallingtree.common.config.enums.SneakMode;
import fr.rakambda.fallingtree.common.config.proxy.ToolProxyConfiguration;
import fr.rakambda.fallingtree.common.config.proxy.TreeProxyConfiguration;
import org.jspecify.annotations.NonNull;

public class ProxyConfiguration
implements IConfiguration,
IResettable {
    private final IConfiguration delegate;
    private final ToolProxyConfiguration toolDelegate;
    private final TreeProxyConfiguration treeDelegate;

    public ProxyConfiguration(IConfiguration delegate) {
        this.delegate = delegate;
        this.toolDelegate = new ToolProxyConfiguration(delegate.getTools());
        this.treeDelegate = new TreeProxyConfiguration(delegate.getTrees());
    }

    @Override
    public void reset() {
        this.toolDelegate.reset();
        this.treeDelegate.reset();
    }

    @Override
    public @NonNull TreeProxyConfiguration getTrees() {
        return this.treeDelegate;
    }

    @Override
    public @NonNull ToolProxyConfiguration getTools() {
        return this.toolDelegate;
    }

    @Override
    public @NonNull IPlayerConfiguration getPlayer() {
        return this.delegate.getPlayer();
    }

    @Override
    public @NonNull IEnchantmentConfiguration getEnchantment() {
        return this.delegate.getEnchantment();
    }

    @Override
    public @NonNull SneakMode getSneakMode() {
        return this.delegate.getSneakMode();
    }

    @Override
    public boolean isBreakInCreative() {
        return this.delegate.isBreakInCreative();
    }

    @Override
    public boolean isLootInCreative() {
        return this.delegate.isLootInCreative();
    }

    @Override
    public @NonNull NotificationMode getNotificationMode() {
        return this.delegate.getNotificationMode();
    }
}

