/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.config.real;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public class ConfigLoader {
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();

    static <T> @NonNull T loadConfig(@NonNull T defaultConfiguration, @NonNull Class<T> clazz, @NonNull Path path) throws IOException {
        Object config = defaultConfiguration;
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                config = gson.fromJson((Reader)reader, clazz);
            }
        }
        if (Objects.isNull(config)) {
            throw new IOException("Read null value from config file");
        }
        return ConfigLoader.saveConfig(config, path);
    }

    static <T> @NonNull T saveConfig(@NonNull T config, @NonNull Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            gson.toJson(config, (Appendable)writer);
        }
        return config;
    }
}

