/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.tree.breaking;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.tree.Tree;
import fr.rakambda.fallingtree.common.wrapper.IBlock;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NonNull;

public class LeafForceBreaker {
    @Generated
    private static final Logger log = LogManager.getLogger(LeafForceBreaker.class);
    private final FallingTreeCommon<?> mod;

    public void forceBreakDecayLeaves(@NonNull IPlayer player, @NonNull Tree tree, @NonNull ILevel level) {
        int radius = this.mod.getConfiguration().getTrees().getLeavesBreakingForceRadius();
        if (radius > 0) {
            tree.getTopMostLog().ifPresent(topLog -> {
                IBlockPos start = topLog.offset(-radius, -radius, -radius);
                IBlockPos end = topLog.offset(radius, radius, radius);
                topLog.betweenClosedStream(start, end).forEach(checkPos -> {
                    IBlockState checkState = level.getBlockState((IBlockPos)checkPos);
                    IBlock checkBlock = checkState.getBlock();
                    if (this.mod.isLeafBlock(checkBlock)) {
                        if (!player.isCreative() || this.mod.getConfiguration().isLootInCreative()) {
                            checkState.dropResources(level, this.mod.getConfiguration().getTrees().isSpawnItemsAtBreakPoint() ? tree.getHitPos() : checkPos);
                        }
                        level.removeBlock((IBlockPos)checkPos, false);
                    }
                });
            });
        }
    }

    @Generated
    public LeafForceBreaker(FallingTreeCommon<?> mod) {
        this.mod = mod;
    }
}

