/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.tree.builder.position;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.tree.TreePartType;
import fr.rakambda.fallingtree.common.tree.builder.ToAnalyzePos;
import fr.rakambda.fallingtree.common.tree.builder.position.IPositionFetcher;
import fr.rakambda.fallingtree.common.wrapper.IBlock;
import fr.rakambda.fallingtree.common.wrapper.IBlockEntity;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.NonNull;

public class AbovePositionFetcher
implements IPositionFetcher {
    private static AbovePositionFetcher INSTANCE;
    private final @NonNull FallingTreeCommon<?> mod;
    private final @NonNull Function<IBlockPos, IBlockPos> lowerPosProvider;

    @Override
    public @NonNull Collection<ToAnalyzePos> getPositions(@NonNull ILevel level, @NonNull IBlockPos originPos, @NonNull ToAnalyzePos parent) {
        IBlockPos parentPos = parent.checkPos();
        IBlock parentBlock = level.getBlockState(parentPos).getBlock();
        return parentPos.betweenClosedStream(parentPos.above().north().east(), this.lowerPosProvider.apply(parentPos).south().west()).map(checkPos -> {
            IBlockState checkedState = level.getBlockState((IBlockPos)checkPos);
            IBlockEntity checkedEntity = level.getBlockEntity((IBlockPos)checkPos);
            IBlock checkBlock = checkedState.getBlock();
            TreePartType treePart = this.mod.getTreePart(checkBlock);
            int logSequence = treePart.isLog() ? 0 : parent.sequenceSinceLastLog() + 1;
            return new ToAnalyzePos(this, parentPos, parentBlock, checkPos.immutable(), checkBlock, checkedState, checkedEntity, treePart, parent.sequence() + 1, logSequence);
        }).collect(Collectors.toList());
    }

    public static AbovePositionFetcher getInstance(@NonNull FallingTreeCommon<?> common) {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new AbovePositionFetcher(common, IBlockPos::above);
        }
        return INSTANCE;
    }

    @Generated
    private AbovePositionFetcher(@NonNull FallingTreeCommon<?> mod, @NonNull Function<IBlockPos, IBlockPos> lowerPosProvider) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        if (lowerPosProvider == null) {
            throw new NullPointerException("lowerPosProvider is marked non-null but is null");
        }
        this.mod = mod;
        this.lowerPosProvider = lowerPosProvider;
    }
}

