/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.forge.common.wrapper;

import fr.rakambda.fallingtree.common.wrapper.IBlock;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IRandomSource;
import fr.rakambda.fallingtree.common.wrapper.IServerLevel;
import fr.rakambda.fallingtree.forge.common.wrapper.BlockWrapper;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jspecify.annotations.NonNull;

public class BlockStateWrapper
implements IBlockState {
    private final @NonNull BlockState raw;

    @Override
    public void tick(@NonNull IServerLevel level, @NonNull IBlockPos blockPos, @NonNull IRandomSource random) {
        ServerLevel l = (ServerLevel)level.getRaw();
        BlockPos bp = (BlockPos)blockPos.getRaw();
        this.raw.tick(l, bp, (RandomSource)random.getRaw());
    }

    @Override
    public void randomTick(@NonNull IServerLevel level, @NonNull IBlockPos blockPos, @NonNull IRandomSource random) {
        ServerLevel l = (ServerLevel)level.getRaw();
        BlockPos bp = (BlockPos)blockPos.getRaw();
        this.raw.randomTick(l, bp, (RandomSource)random.getRaw());
    }

    @Override
    public @NonNull IBlock getBlock() {
        return new BlockWrapper(this.raw.getBlock());
    }

    @Override
    public boolean isRandomlyTicking() {
        return this.raw.isRandomlyTicking();
    }

    @Override
    public @NonNull Optional<Boolean> hasLeafPersistentFlag() {
        return this.raw.getOptionalValue((Property)LeavesBlock.PERSISTENT);
    }

    @Override
    public void dropResources(@NonNull ILevel level, @NonNull IBlockPos blockPos) {
        Block.dropResources((BlockState)this.raw, (Level)((Level)level.getRaw()), (BlockPos)((BlockPos)blockPos.getRaw()));
    }

    @Generated
    public BlockStateWrapper(@NonNull BlockState raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        this.raw = raw;
    }

    @Generated
    public String toString() {
        return "BlockStateWrapper(raw=" + String.valueOf(this.getRaw()) + ")";
    }

    @Generated
    public @NonNull BlockState getRaw() {
        return this.raw;
    }
}

