/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.rightclickharvest;

import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import io.github.jamalam360.jamlib.JamLib;
import io.github.jamalam360.jamlib.JamLibPlatform;
import io.github.jamalam360.jamlib.config.ConfigManager;
import io.github.jamalam360.rightclickharvest.Config;
import io.github.jamalam360.rightclickharvest.HarvestContext;
import io.github.jamalam360.rightclickharvest.HelloPacket;
import io.github.jamalam360.rightclickharvest.RightClickHarvestPlatform;
import io.github.jamalam360.rightclickharvest.ServerLangProvider;
import io.github.jamalam360.rightclickharvest.mixin.CropBlockAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RightClickHarvest {
    public static final String MOD_ID = "rightclickharvest";
    public static final String MOD_NAME = "Right Click Harvest";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Right Click Harvest");
    public static final ConfigManager<Config> CONFIG = new ConfigManager("rightclickharvest", Config.class);
    public static final TagKey<Block> BLACKLIST = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)RightClickHarvest.id("blacklist"));
    public static final TagKey<Block> HOE_NEVER_REQUIRED = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)RightClickHarvest.id("hoe_never_required"));
    public static final TagKey<Block> RADIUS_HARVEST_BLACKLIST = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)RightClickHarvest.id("radius_harvest_blacklist"));
    public static final TagKey<Item> LOW_TIER_HOES = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)RightClickHarvest.id("low_tier_hoes"));
    public static final TagKey<Item> MID_TIER_HOES = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)RightClickHarvest.id("mid_tier_hoes"));
    public static final TagKey<Item> HIGH_TIER_HOES = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)RightClickHarvest.id("high_tier_hoes"));
    public static final Direction[] CARDINAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static final IntProvider XP_PROVIDER = UniformInt.of((int)0, (int)2);
    private static final List<UUID> PLAYERS_WARNED_FOR_NOT_USING_HOE = new ArrayList<UUID>();

    public static void init() {
        LOGGER.info("Initializing Right Click Harvest on {}", (Object)JamLibPlatform.getPlatform().name());
        JamLib.checkForJarRenaming(RightClickHarvest.class);
        if (Platform.getEnvironment() == Env.SERVER) {
            NetworkManager.registerS2CPayloadType(HelloPacket.TYPE, HelloPacket.STREAM_CODEC);
        }
        PlayerEvent.PLAYER_JOIN.register(player -> {
            if (NetworkManager.canPlayerReceive((ServerPlayer)player, HelloPacket.TYPE)) {
                NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new HelloPacket());
            }
        });
        InteractionEvent.RIGHT_CLICK_BLOCK.register((player, hand, pos, face) -> RightClickHarvest.onBlockUse(player, player.level(), hand, new BlockHitResult(player.position(), face, pos, false), true));
    }

    @ApiStatus.Internal
    public static InteractionResult onBlockUse(Player player, Level level, InteractionHand hand, BlockHitResult hitResult, boolean initialCall) {
        if (player.isSpectator() || player.isCrouching() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        BlockState state = level.getBlockState(hitResult.getBlockPos());
        ItemStack stackInHand = player.getItemInHand(hand);
        boolean hoeInUse = false;
        if (state.is(BLACKLIST)) {
            return InteractionResult.PASS;
        }
        if (((Config)RightClickHarvest.CONFIG.get()).hungerLevel != Config.HungerLevel.NONE && !player.getAbilities().instabuild && player.getFoodData().getFoodLevel() <= 0) {
            return InteractionResult.PASS;
        }
        if (((Config)RightClickHarvest.CONFIG.get()).experienceType == Config.ExperienceType.COST && !player.getAbilities().instabuild && player.experienceLevel < XP_PROVIDER.getMaxValue()) {
            return InteractionResult.PASS;
        }
        if (!state.is(HOE_NEVER_REQUIRED) && ((Config)RightClickHarvest.CONFIG.get()).requireHoe) {
            if (!RightClickHarvest.isHoe(stackInHand)) {
                RightClickHarvest.warnPlayerForNotUsingHoe(player, state, stackInHand);
                return InteractionResult.PASS;
            }
            hoeInUse = true;
        }
        if (!initialCall && state.is(RADIUS_HARVEST_BLACKLIST)) {
            return InteractionResult.PASS;
        }
        if (state.getBlock() instanceof CocoaBlock || state.getBlock() instanceof CropBlock || state.getBlock() instanceof NetherWartBlock) {
            if (RightClickHarvest.isMature(state)) {
                if (initialCall && ((Config)RightClickHarvest.CONFIG.get()).harvestInRadius && !state.is(RADIUS_HARVEST_BLACKLIST) && RightClickHarvest.isHoe(stackInHand)) {
                    int radius = 0;
                    boolean circle = false;
                    hoeInUse = true;
                    if (stackInHand.is(HIGH_TIER_HOES)) {
                        radius = 2;
                        circle = true;
                    } else if (stackInHand.is(MID_TIER_HOES)) {
                        radius = 1;
                        circle = false;
                    } else if (stackInHand.is(LOW_TIER_HOES)) {
                        radius = 1;
                        circle = true;
                    }
                    if (radius == 1 && circle) {
                        for (Direction dir : CARDINAL_DIRECTIONS) {
                            RightClickHarvest.onBlockUse(player, level, hand, hitResult.withPosition(hitResult.getBlockPos().relative(dir)), false);
                        }
                    } else if (radius > 0) {
                        for (int x = -radius; x <= radius; ++x) {
                            for (int z = -radius; z <= radius; ++z) {
                                if (x == 0 && z == 0) continue;
                                BlockPos pos = hitResult.getBlockPos().relative(Direction.Axis.X, x).relative(Direction.Axis.Z, z);
                                if (circle && pos.distManhattan((Vec3i)hitResult.getBlockPos()) > radius) continue;
                                RightClickHarvest.onBlockUse(player, level, hand, hitResult.withPosition(pos), false);
                            }
                        }
                    }
                }
                return RightClickHarvest.completeHarvest(level, state, hitResult.getBlockPos(), player, hand, stackInHand, hoeInUse, true, () -> level.setBlockAndUpdate(hitResult.getBlockPos(), RightClickHarvest.getReplantState(state)));
            }
        } else if (state.getBlock() instanceof SugarCaneBlock || state.getBlock() instanceof CactusBlock) {
            if (hitResult.getDirection() == Direction.UP && (stackInHand.getItem() == Items.SUGAR_CANE && state.getBlock() instanceof SugarCaneBlock || stackInHand.getItem() == Items.CACTUS && state.getBlock() instanceof CactusBlock)) {
                return InteractionResult.PASS;
            }
            Block lookingFor = state.getBlock() instanceof SugarCaneBlock ? Blocks.SUGAR_CANE : Blocks.CACTUS;
            BlockPos bottom = hitResult.getBlockPos();
            while (level.getBlockState(bottom.below()).is(lookingFor)) {
                bottom = bottom.below();
            }
            if (!level.getBlockState(bottom.above()).is(lookingFor)) {
                return InteractionResult.PASS;
            }
            BlockPos breakPos = bottom.above(1);
            return RightClickHarvest.completeHarvest(level, state, breakPos, player, hand, stackInHand, hoeInUse, false, () -> level.removeBlock(breakPos, false));
        }
        return InteractionResult.PASS;
    }

    private static void warnPlayerForNotUsingHoe(Player player, BlockState state, ItemStack stackInHand) {
        ServerPlayer serverPlayer;
        if (!RightClickHarvest.isHarvestable(state) || !stackInHand.isEmpty()) {
            return;
        }
        if (player.level().isClientSide) {
            if (!((Config)RightClickHarvest.CONFIG.get()).hasUserBeenWarnedForNotUsingHoe) {
                player.displayClientMessage((Component)Component.translatable((String)"text.rightclickharvest.use_a_hoe_warning", (Object[])new Object[]{Component.translatable((String)"config.rightclickharvest.requireHoe").withStyle(s -> s.withColor(ChatFormatting.GREEN)), Component.literal((String)"false").withStyle(s -> s.withColor(ChatFormatting.GREEN))}), false);
                ((Config)RightClickHarvest.CONFIG.get()).hasUserBeenWarnedForNotUsingHoe = true;
                CONFIG.save();
            }
        } else if (player instanceof ServerPlayer && !NetworkManager.canPlayerReceive((ServerPlayer)(serverPlayer = (ServerPlayer)player), HelloPacket.TYPE) && !PLAYERS_WARNED_FOR_NOT_USING_HOE.contains(player.getUUID())) {
            String playerLang = serverPlayer.clientInformation().language();
            player.displayClientMessage((Component)Component.translatable((String)ServerLangProvider.getUseHoeMessageByLanguage(playerLang), (Object[])new Object[]{Component.literal((String)ServerLangProvider.getRequireHoeConfigByLanguage(playerLang)).withStyle(s -> s.withColor(ChatFormatting.GREEN)), Component.literal((String)"false").withStyle(s -> s.withColor(ChatFormatting.GREEN))}), false);
            PLAYERS_WARNED_FOR_NOT_USING_HOE.add(player.getUUID());
        }
    }

    private static InteractionResult completeHarvest(Level level, BlockState state, BlockPos pos, Player player, InteractionHand hand, ItemStack stackInHand, boolean hoeInUse, boolean removeReplant, Runnable setBlockAction) {
        if (!level.isClientSide) {
            Block originalBlock = state.getBlock();
            if (RightClickHarvestPlatform.postBreakEvent(level, pos, state, player)) {
                return InteractionResult.FAIL;
            }
            if (RightClickHarvestPlatform.postPlaceEvent(level, pos, player)) {
                return InteractionResult.FAIL;
            }
            RightClickHarvest.dropStacks(state, (ServerLevel)level, pos, (Entity)player, player.getItemInHand(hand), removeReplant);
            setBlockAction.run();
            if (hoeInUse) {
                stackInHand.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            }
            player.causeFoodExhaustion(0.008f * ((Config)RightClickHarvest.CONFIG.get()).hungerLevel.modifier);
            int xp = switch (((Config)RightClickHarvest.CONFIG.get()).experienceType) {
                default -> throw new MatchException(null, null);
                case Config.ExperienceType.COST -> -XP_PROVIDER.sample(player.getRandom());
                case Config.ExperienceType.REWARD -> XP_PROVIDER.sample(player.getRandom());
                case Config.ExperienceType.NONE -> 0;
            };
            player.giveExperiencePoints(xp);
            RightClickHarvestPlatform.postAfterHarvestEvent(new HarvestContext(player, originalBlock));
        } else {
            player.playSound(state.getBlock() instanceof NetherWartBlock ? SoundEvents.NETHER_WART_PLANTED : SoundEvents.CROP_PLANTED, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    private static boolean isHarvestable(BlockState state) {
        if (state.getBlock() instanceof CocoaBlock || state.getBlock() instanceof CropBlock || state.getBlock() instanceof NetherWartBlock) {
            return RightClickHarvest.isMature(state);
        }
        return state.getBlock() instanceof SugarCaneBlock || state.getBlock() instanceof CactusBlock;
    }

    private static boolean isHoe(ItemStack stack) {
        return stack.is(ItemTags.HOES) || stack.is(LOW_TIER_HOES) || stack.is(MID_TIER_HOES) || stack.is(HIGH_TIER_HOES) || RightClickHarvestPlatform.isHoeAccordingToPlatform(stack);
    }

    private static boolean isMature(BlockState state) {
        if (state.getBlock() instanceof CocoaBlock) {
            return (Integer)state.getValue((Property)CocoaBlock.AGE) >= 2;
        }
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.isMaxAge(state);
        }
        if (state.getBlock() instanceof NetherWartBlock) {
            return (Integer)state.getValue((Property)NetherWartBlock.AGE) >= 3;
        }
        return false;
    }

    private static BlockState getReplantState(BlockState state) {
        if (state.getBlock() instanceof CocoaBlock) {
            return (BlockState)state.setValue((Property)CocoaBlock.AGE, (Comparable)Integer.valueOf(0));
        }
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return (BlockState)state.setValue((Property)((CropBlockAccessor)cropBlock).invokeGetAgeProperty(), (Comparable)Integer.valueOf(0));
        }
        if (state.getBlock() instanceof NetherWartBlock) {
            return (BlockState)state.setValue((Property)NetherWartBlock.AGE, (Comparable)Integer.valueOf(0));
        }
        return state;
    }

    private static void dropStacks(BlockState state, ServerLevel world, BlockPos pos, Entity entity, ItemStack toolStack, boolean removeReplant) {
        Item replant = state.getCloneItemStack((LevelReader)world, pos, true).getItem();
        boolean[] removedReplant = new boolean[]{!removeReplant};
        Block.getDrops((BlockState)state, (ServerLevel)world, (BlockPos)pos, null, (Entity)entity, (ItemStack)toolStack).forEach(stack -> {
            if (!removedReplant[0] && stack.getItem() == replant) {
                stack.setCount(stack.getCount() - 1);
                removedReplant[0] = true;
            }
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)stack);
        });
        state.spawnAfterBreak(world, pos, toolStack, true);
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

