/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io.nbt;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import java.util.Optional;
import journeymap.common.Journeymap;
import journeymap.common.mixin.common.SerializableChunkDataInvoker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.Logger;

public class CustomChunkReader {
    private static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC;
    private static final Logger logger;

    public static ProcessedChunk read(ClientLevel level, ChunkPos chunkPos, CompoundTag chunkTag) {
        block8: {
            try {
                if (ChunkType.LEVELCHUNK != SerializableChunkData.getChunkStatusFromTag((CompoundTag)chunkTag).getChunkType()) break block8;
                DataLayer lights = null;
                boolean lightOn = chunkTag.getBoolean("isLightOn").orElse(false);
                ListTag sections = (ListTag)chunkTag.getList("sections").get();
                int sectionsCount = level.getSectionsCount();
                LevelChunkSection[] chunkSections = new LevelChunkSection[sectionsCount];
                Registry registry = level.registryAccess().lookupOrThrow(Registries.BIOME);
                Codec<PalettedContainerRO<Holder<Biome>>> codec = SerializableChunkDataInvoker.invokeMakeBiomeCodec((Registry<Biome>)registry);
                for (int j = 0; j < sections.size(); ++j) {
                    CompoundTag section = (CompoundTag)sections.getCompound(j).get();
                    byte sectionTopY = (Byte)section.getByte("Y").get();
                    int sectionIndex = level.getSectionIndexFromSectionY((int)sectionTopY);
                    if (sectionIndex >= 0 && sectionIndex < chunkSections.length) {
                        LevelChunkSection chunkSection;
                        PalettedContainer blockStateContainer = section.contains("block_states") ? (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)((Tag)section.getCompound("block_states").get())).promotePartial(stringx -> CustomChunkReader.logErrors(chunkPos, sectionTopY, stringx)).getOrThrow(SerializableChunkData.ChunkReadException::new) : new PalettedContainer((IdMap)Block.BLOCK_STATE_REGISTRY, (Object)Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES);
                        Object biomeContainer = section.contains("biomes") ? (PalettedContainerRO)codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)((Tag)section.getCompound("biomes").get())).promotePartial(stringx -> CustomChunkReader.logErrors(chunkPos, sectionTopY, stringx)).getOrThrow(SerializableChunkData.ChunkReadException::new) : new PalettedContainer(registry.asHolderIdMap(), (Object)registry.getOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES);
                        chunkSections[sectionIndex] = chunkSection = new LevelChunkSection(blockStateContainer, (PalettedContainerRO)biomeContainer);
                    }
                    if (!lightOn || !section.contains("BlockLight")) continue;
                    byte[] lightsArray = (byte[])section.getByteArray("BlockLight").get();
                    lights = new DataLayer(lightsArray);
                }
                LevelChunk chunkAccess = null;
                CompoundTag heightmaps = null;
                EnumSet<Heightmap.Types> heightmapEnums = null;
                try {
                    chunkAccess = new LevelChunk((Level)level, chunkPos, null, null, null, 0L, chunkSections, null, null);
                    chunkAccess.setLightCorrect(lightOn);
                    Optional heightmapsOptional = chunkTag.getCompound("Heightmaps");
                    heightmapEnums = EnumSet.noneOf(Heightmap.Types.class);
                    heightmaps = heightmapsOptional.isPresent() ? (CompoundTag)heightmapsOptional.get() : new CompoundTag();
                }
                catch (Exception e) {
                    throw new AutoMapChunkReaderException("Error creating LevelChunk during automap", e);
                }
                for (Heightmap.Types heightmapTypes : chunkAccess.getPersistedStatus().heightmapsAfter()) {
                    String key = heightmapTypes.getSerializationKey();
                    if (heightmaps.contains(key)) {
                        chunkAccess.setHeightmap(heightmapTypes, (long[])heightmaps.getLongArray(key).get());
                        continue;
                    }
                    heightmapEnums.add(heightmapTypes);
                }
                Heightmap.primeHeightmaps((ChunkAccess)chunkAccess, heightmapEnums);
                return new ProcessedChunk(chunkAccess, lights);
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error parsing chunk during automap >>", (Throwable)e);
            }
        }
        return null;
    }

    public static void logErrors(ChunkPos chunkPos, int chunkSectionY, String errorMessage) {
        logger.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{chunkPos.x, chunkSectionY, chunkPos.z, errorMessage});
    }

    static {
        logger = Journeymap.getLogger();
        BLOCK_STATE_CODEC = PalettedContainer.codecRW((IdMap)Block.BLOCK_STATE_REGISTRY, (Codec)BlockState.CODEC, (PalettedContainer.Strategy)PalettedContainer.Strategy.SECTION_STATES, (Object)Blocks.AIR.defaultBlockState());
    }

    static class AutoMapChunkReaderException
    extends RuntimeException {
        public AutoMapChunkReaderException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public record ProcessedChunk(LevelChunk chunk, DataLayer light) {
    }
}

