/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import journeymap.api.v2.client.display.ImageOverlay;
import journeymap.api.v2.client.model.MapImage;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.client.render.draw.BaseOverlayDrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Renderer;
import journeymap.client.texture.TextureCache;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class DrawImageStep
extends BaseOverlayDrawStep<ImageOverlay> {
    private Point2D.Double northWestPosition;
    private Point2D.Double southEastPosition;
    private AbstractTexture iconTexture;
    private boolean hasError;

    public DrawImageStep(ImageOverlay marker) {
        super(marker);
    }

    @Override
    public void draw(GuiGraphics graphics, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        if (!this.isOnScreen(xOffset, yOffset, renderer, rotation)) {
            return;
        }
        this.ensureTexture();
        if (!this.hasError && this.iconTexture != null) {
            MapImage icon = ((ImageOverlay)this.overlay).getImage();
            double width = this.screenBounds.width;
            double height = this.screenBounds.height;
            DrawUtil.drawTexture(graphics, icon.getImageLocation(), icon.getColor(), icon.getOpacity(), this.northWestPosition.x + xOffset, this.northWestPosition.y + yOffset, width, height, (double)icon.getRotation() - rotation, false, icon.isBlur(), false);
        }
        super.drawText(graphics, xOffset, yOffset, renderer, fontScale, rotation);
    }

    protected void ensureTexture() {
        if (this.iconTexture != null) {
            return;
        }
        try {
            MapImage image = ((ImageOverlay)this.overlay).getImage();
            ResourceLocation resourceLocation = image.getImageLocation();
            ResourceLocation fake = ResourceLocation.fromNamespaceAndPath((String)"fake", (String)CommonConstants.getSafeString(((ImageOverlay)this.overlay).getGuid(), "-").toLowerCase(Locale.ROOT));
            if (resourceLocation == null) {
                DynamicTexture texture = new DynamicTexture(null, image.getImage());
                Minecraft.getInstance().getTextureManager().register(fake, (AbstractTexture)texture);
                this.iconTexture = TextureCache.getTexture(fake);
            } else {
                this.iconTexture = TextureCache.getTexture(resourceLocation);
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error getting ImageOverlay marimage upperTexture: " + String.valueOf(e), (Throwable)e);
            this.hasError = true;
        }
    }

    @Override
    protected void updatePositions(Renderer renderer, double rotation) {
        this.northWestPosition = renderer.getBlockPixelInGrid(((ImageOverlay)this.overlay).getNorthWestPoint());
        this.southEastPosition = renderer.getBlockPixelInGrid(((ImageOverlay)this.overlay).getSouthEastPoint());
        this.screenBounds = new Rectangle2D.Double(this.northWestPosition.x, this.northWestPosition.y, 0.0, 0.0);
        this.screenBounds.add(this.southEastPosition);
        TextProperties textProperties = ((ImageOverlay)this.overlay).getTextProperties();
        this.labelPosition.setLocation(this.screenBounds.getCenterX() + (double)textProperties.getOffsetX(), this.screenBounds.getCenterY() + (double)textProperties.getOffsetY());
    }

    public static class SimpleCacheLoader
    extends CacheLoader<ImageOverlay, DrawImageStep> {
        public DrawImageStep load(ImageOverlay overlay) throws Exception {
            return new DrawImageStep(overlay);
        }
    }
}

