/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import journeymap.api.services.Services;
import journeymap.api.v2.client.util.tuple.Tuple2;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.io.FileHandler;
import journeymap.client.model.entity.EntityDTO;
import journeymap.client.model.entity.GeckoLibHelper;
import journeymap.client.render.draw.LivingEntityRendererETFTextureGetter;
import journeymap.client.texture.IgnSkin;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.common.Journeymap;
import journeymap.common.accessors.NativeImageAccess;
import journeymap.common.log.LogFormatter;
import journeymap.common.mixin.client.AgeableMobRendererAccessor;
import journeymap.common.mixin.client.EnderDragonModelMixin;
import journeymap.common.mixin.client.EnderDragonRendererMixin;
import journeymap.common.mixin.client.ModelPartMixin;
import journeymap.common.mixin.client.PufferfishRendererMixin;
import journeymap.common.mixin.client.RabbitModelMixin;
import journeymap.common.mixin.client.SalmonRendererInvoker;
import journeymap.common.mixin.client.TropicalFishRendererMixin;
import journeymap.common.util.ReflectionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.CamelModel;
import net.minecraft.client.model.DolphinModel;
import net.minecraft.client.model.DonkeyModel;
import net.minecraft.client.model.EndermiteModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.LavaSlimeModel;
import net.minecraft.client.model.LlamaModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.ParrotModel;
import net.minecraft.client.model.RabbitModel;
import net.minecraft.client.model.SalmonModel;
import net.minecraft.client.model.SilverfishModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.VillagerLikeModel;
import net.minecraft.client.model.dragon.EnderDragonModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.PufferfishRenderer;
import net.minecraft.client.renderer.entity.SalmonRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.TropicalFishRenderState;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class MobIconCache {
    private static final String MOB_ICON_FILE_SUFFIX = ".png";
    private static final String OUTLINED_SUFFIX = "_outlined";
    private static HashMap<ResourceLocation, IconTexture> mobsIcons = null;
    private static final Map<ResourceLocation, DynamicTexture> webMapIconCache = Collections.synchronizedMap(new HashMap());
    private static NativeImage markerMask = null;

    public static DynamicTexture getWebMapIcon(ResourceLocation loc) {
        return webMapIconCache.get(loc);
    }

    public static Tuple2<ResourceLocation, DynamicTexture> getMobIcon(EntityDTO dto, boolean outlined) {
        MobIconCache.ensureMobIconsLoaded();
        ResourceLocation mobLocation = dto.entityTypeLocation;
        MobIconCache.addIconIfMissing(dto, mobLocation);
        IconTexture icon = mobsIcons.get(mobLocation);
        if ((JourneymapClient.getInstance().getCoreProperties().legacyIcons.get().booleanValue() || dto.hasCustomIcon || icon == null) && dto.entityIconLocation != null && RenderSystem.isOnRenderThread()) {
            try {
                DynamicTexture tex = (DynamicTexture)TextureCache.getTexture(dto.entityIconLocation);
                if (tex != null && ((TextureAccess)tex).journeymap$hasImage()) {
                    mobsIcons.put(dto.entityIconLocation, new IconTexture(tex, null));
                    webMapIconCache.put(dto.entityIconLocation, tex);
                    return new Tuple2((Object)dto.entityIconLocation, (Object)tex);
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error getting texture location for texture {}", (Object)dto.entityTextureLocation, (Object)e);
            }
        }
        if (icon == null) {
            return null;
        }
        if (outlined) {
            webMapIconCache.put(mobLocation.withPath(mobLocation.getPath() + OUTLINED_SUFFIX), icon.outlined);
            return new Tuple2((Object)mobLocation.withPath(mobLocation.getPath() + OUTLINED_SUFFIX), (Object)icon.outlined);
        }
        webMapIconCache.put(mobLocation, icon.solid);
        return new Tuple2((Object)mobLocation, (Object)icon.solid);
    }

    private static void ensureMobIconsLoaded() {
        if (mobsIcons == null) {
            mobsIcons = new HashMap();
            markerMask = ((DynamicTexture)TextureCache.getTexture(TextureCache.MobIconMask)).getPixels();
            ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
            Set resourceStacks = resourceManager.listResourceStacks("icon/entity", loc -> loc.getPath().endsWith(MOB_ICON_FILE_SUFFIX) && loc.getNamespace().equals("journeymap")).entrySet();
            for (Map.Entry resources : resourceStacks) {
                HashMap<ResourceLocation, IconTexture> icons = new HashMap<ResourceLocation, IconTexture>();
                for (Resource resource : (List)resources.getValue()) {
                    try {
                        boolean outlined;
                        String mobName;
                        ResourceLocation mobLoc;
                        NativeImage icon = FileHandler.getImageFromStream(resource.open());
                        String[] path = ((ResourceLocation)resources.getKey()).getPath().split("/");
                        if (path.length != 4 || mobsIcons.containsKey(mobLoc = ResourceLocation.fromNamespaceAndPath((String)path[2], (String)(mobName = (outlined = (mobName = path[3]).endsWith("_outlined.png")) ? mobName.replaceAll("_outlined.png", "") : mobName.replaceAll(MOB_ICON_FILE_SUFFIX, ""))))) continue;
                        MobIconCache.addIcon(icons, mobLoc, icon, outlined);
                    }
                    catch (Throwable t) {
                        Journeymap.getLogger().error("Could not load Mob icon: {}", (Object)LogFormatter.toString(t));
                    }
                }
                MobIconCache.addMissingSolidOrOutlined(icons);
                mobsIcons.putAll(icons);
            }
            File[] domainsDirs = FileHandler.getMobIconsDomainsDirectories();
            HashMap<ResourceLocation, IconTexture> icons = new HashMap<ResourceLocation, IconTexture>();
            for (File domainDir : domainsDirs) {
                File[] mobsFiles;
                if (!ResourceLocation.isValidNamespace((String)domainDir.getName()) || (mobsFiles = domainDir.listFiles((dir, name) -> name.endsWith(MOB_ICON_FILE_SUFFIX))) == null) continue;
                for (File mobFile : mobsFiles) {
                    try {
                        String mobName = mobFile.getName();
                        boolean outlined = mobName.endsWith("_outlined.png");
                        mobName = outlined ? mobName.replaceAll("_outlined.png", "") : mobName.replaceAll(MOB_ICON_FILE_SUFFIX, "");
                        NativeImage icon = FileHandler.getImageFromFile(mobFile);
                        ResourceLocation mobLoc = ResourceLocation.fromNamespaceAndPath((String)domainDir.getName(), (String)mobName);
                        if (mobsIcons.containsKey(mobLoc)) continue;
                        MobIconCache.addIcon(icons, mobLoc, icon, outlined);
                    }
                    catch (Throwable t) {
                        Journeymap.getLogger().error("Could not load Mob icon: {}", (Object)LogFormatter.toString(t));
                    }
                }
            }
            MobIconCache.addMissingSolidOrOutlined(icons);
            mobsIcons.putAll(icons);
        }
    }

    public static void clearCache() {
        webMapIconCache.clear();
        if (mobsIcons != null && !mobsIcons.isEmpty()) {
            mobsIcons.forEach((resource, tex) -> {
                if (tex != null) {
                    Minecraft.getInstance().getTextureManager().release(resource);
                    tex.remove();
                }
            });
        }
        mobsIcons = null;
    }

    private static void addIcon(Map<ResourceLocation, IconTexture> icons, ResourceLocation mob, NativeImage icon, boolean outlined) {
        IconTexture iconTexture = icons.computeIfAbsent(mob, m -> new IconTexture());
        DynamicTexture texture = new DynamicTexture(null, icon);
        if (outlined) {
            iconTexture.outlined = texture;
        } else {
            iconTexture.solid = texture;
        }
    }

    private static void addMissingSolidOrOutlined(Map<ResourceLocation, IconTexture> icons) {
        icons.forEach((key, icon) -> {
            if (icon.solid == null) {
                icon.solid = icon.outlined;
            } else if (icon.outlined == null) {
                icon.outlined = icon.solid;
            }
            ResourceLocation outlinedLocation = key.withPath(key.getPath() + OUTLINED_SUFFIX);
            Minecraft.getInstance().getTextureManager().register(key, (AbstractTexture)icon.solid);
            Minecraft.getInstance().getTextureManager().register(outlinedLocation, (AbstractTexture)icon.outlined);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addIconIfMissing(EntityDTO dto, ResourceLocation mobLocation) {
        boolean saveToDisk;
        NativeImage entityIcon;
        block31: {
            NativeImage entityImage;
            EntityRenderer renderer;
            block33: {
                EntityModel texture;
                LivingEntityRenderer mobRenderer;
                Entity entity;
                block40: {
                    RabbitModel model;
                    ResourceLocation textureLocation;
                    block39: {
                        Object parts;
                        SalmonModel rendererModel;
                        block35: {
                            block38: {
                                block37: {
                                    VillagerData data;
                                    VillagerProfession profession;
                                    ResourceLocation professionKey;
                                    block36: {
                                        block34: {
                                            block32: {
                                                if (mobsIcons.containsKey(mobLocation)) return;
                                                if (!RenderSystem.isOnRenderThread()) return;
                                                entityIcon = null;
                                                saveToDisk = true;
                                                entity = (Entity)dto.getEntityRef().get();
                                                if (entity == null) break block31;
                                                EntityRenderDispatcher renderManager = Minecraft.getInstance().getEntityRenderDispatcher();
                                                renderer = renderManager.getRenderer(entity);
                                                textureLocation = MobIconCache.getTextureLocation(renderManager.getRenderer(entity), entity, dto);
                                                DynamicTexture tex = (DynamicTexture)TextureCache.getTexture(textureLocation);
                                                if (tex == null || !((TextureAccess)tex).journeymap$hasImage()) {
                                                    mobsIcons.put(mobLocation, null);
                                                    return;
                                                }
                                                entityImage = tex.getPixels();
                                                if (!ReflectionHelper.isInstanceOf(renderer, "software.bernie.geckolib.renderer.GeoEntityRenderer")) break block32;
                                                boolean isFish = entity instanceof AbstractFish;
                                                List<ModelPart> head = GeckoLibHelper.getModelParts(entity, mobLocation, !isFish);
                                                entityIcon = MobIconCache.getIconFromHead(head, entityImage, mobLocation, isFish);
                                                if (entityIcon == null) {
                                                    entityIcon = MobIconCache.getIconFromHead(head, entityImage, mobLocation, !isFish);
                                                }
                                                break block31;
                                            }
                                            if (!(renderer instanceof LivingEntityRenderer)) break block33;
                                            mobRenderer = (LivingEntityRenderer)renderer;
                                            if (renderer instanceof AgeableMobRenderer) {
                                                AgeableMobRenderer ageableMobRenderer = (AgeableMobRenderer)renderer;
                                                r = (AgeableMobRendererAccessor)ageableMobRenderer;
                                                rendererModel = r.getAdultModel();
                                            } else if (renderer instanceof PufferfishRenderer) {
                                                PufferfishRenderer pufferfishRenderer = (PufferfishRenderer)renderer;
                                                r = (PufferfishRendererMixin)pufferfishRenderer;
                                                rendererModel = r.getBigModel();
                                            } else if (renderer instanceof SalmonRenderer) {
                                                SalmonRenderer salmonRenderer = (SalmonRenderer)renderer;
                                                r = (SalmonRendererInvoker)salmonRenderer;
                                                rendererModel = r.getMediumSalmonModel();
                                            } else {
                                                rendererModel = mobRenderer.getModel();
                                            }
                                            parts = ImmutableList.of();
                                            if (!(rendererModel instanceof SlimeModel) && !(rendererModel instanceof LavaSlimeModel) && !(rendererModel instanceof SilverfishModel) && !(rendererModel instanceof EndermiteModel)) break block34;
                                            parts = rendererModel.allParts();
                                            break block35;
                                        }
                                        if (!(rendererModel instanceof RabbitModel)) break block36;
                                        model = (RabbitModel)rendererModel;
                                        RabbitModelMixin m = (RabbitModelMixin)model;
                                        parts = ImmutableList.of((Object)m.getHead());
                                        break block35;
                                    }
                                    if (!(rendererModel instanceof VillagerLikeModel) || !(rendererModel instanceof HeadedModel)) break block37;
                                    HeadedModel headedModel = (HeadedModel)rendererModel;
                                    if (!(entity instanceof VillagerDataHolder)) break block35;
                                    VillagerDataHolder villager = (VillagerDataHolder)entity;
                                    String type = entity instanceof Villager ? "villager" : (entity instanceof ZombieVillager ? "zombie_villager" : null);
                                    if (type != null && (professionKey = BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)(profession = (VillagerProfession)(data = villager.getVillagerData()).profession().value()))) != VillagerProfession.NONE.location()) {
                                        ResourceLocation professionRes = professionKey.withPath($$1x -> "textures/entity/" + type + "/profession/" + $$1x + MOB_ICON_FILE_SUFFIX);
                                        NativeImage altEntityImage = MobIconCache.mergeImages(entityImage, professionRes);
                                        entityIcon = MobIconCache.getIconFromHead(headedModel.getHead(), altEntityImage, mobLocation, false);
                                        if (altEntityImage != entityImage) {
                                            altEntityImage.close();
                                        }
                                    }
                                    break block35;
                                }
                                if (!(renderer instanceof TropicalFishRenderer)) break block38;
                                TropicalFishRenderer tropicalFishRenderer = (TropicalFishRenderer)renderer;
                                if (entity instanceof TropicalFish) {
                                    NativeImage altEntityImage;
                                    EntityModel<TropicalFishRenderState> tropicalFishModel;
                                    TropicalFish tropicalFish = (TropicalFish)entity;
                                    if (tropicalFish.getPattern().base() == TropicalFish.Base.SMALL) {
                                        tropicalFishModel = ((TropicalFishRendererMixin)tropicalFishRenderer).getModelA();
                                        altEntityImage = MobIconCache.mergeImages(entityImage, ResourceLocation.parse((String)"textures/entity/fish/tropical_a_pattern_1.png"), 0xFF0000, 0xFFFFFF);
                                    } else {
                                        tropicalFishModel = ((TropicalFishRendererMixin)tropicalFishRenderer).getModelB();
                                        altEntityImage = MobIconCache.mergeImages(entityImage, ResourceLocation.parse((String)"textures/entity/fish/tropical_b_pattern_4.png"), 8991416, 16701501);
                                    }
                                    ModelPart body = tropicalFishModel.root();
                                    entityIcon = MobIconCache.getIconFromHead(body, altEntityImage, mobLocation, true);
                                    if (altEntityImage != entityImage) {
                                        altEntityImage.close();
                                    }
                                }
                                break block35;
                            }
                            if (entity instanceof AbstractFish || rendererModel instanceof DolphinModel) {
                                parts = ImmutableList.of((Object)rendererModel.root());
                            }
                        }
                        if (entityIcon != null) break block31;
                        if (parts.isEmpty()) {
                            Optional<ModelPart> headPart = MobIconCache.getAnyDescendantWithName(rendererModel.root(), "head");
                            if (headPart.isEmpty()) {
                                headPart = MobIconCache.getAnyDescendantWithName(rendererModel.root(), "body");
                            }
                            parts = ImmutableList.of((Object)headPart.orElseGet(() -> ((Model)rendererModel).root()));
                        }
                        if (parts.isEmpty()) break block39;
                        boolean rotated = rendererModel instanceof HorseModel || rendererModel instanceof LlamaModel || rendererModel instanceof CamelModel || rendererModel instanceof DonkeyModel || rendererModel instanceof ParrotModel || rendererModel instanceof DolphinModel || entity instanceof AbstractFish;
                        entityIcon = MobIconCache.getIconFromHead((Iterable<ModelPart>)parts, entityImage, mobLocation, rotated);
                        if (entityIcon == null) {
                            entityIcon = MobIconCache.getIconFromHead((Iterable<ModelPart>)parts, entityImage, mobLocation, !rotated);
                        }
                        break block31;
                    }
                    EntityModel rotated = mobRenderer.getModel();
                    if (!(rotated instanceof EntityModel)) break block40;
                    model = rotated;
                    if (!ReflectionHelper.isInstanceOf(mobRenderer.getModel(), "com.cobblemon.mod.common.client.render.models.blockbench.npc.PosableNPCModel")) break block40;
                    saveToDisk = false;
                    texture = (DynamicTexture)TextureCache.getTexture(textureLocation);
                    entityIcon = IgnSkin.cropToFace(texture.getPixels());
                    entityIcon = MobIconCache.cropImage(entityIcon);
                    entityIcon = MobIconCache.resizeImage(entityIcon, 4, false);
                    MobIconCache.maskImage(entityIcon);
                    break block31;
                }
                if ((texture = mobRenderer.getModel()) instanceof EntityModel) {
                    Optional head;
                    EntityModel model = texture;
                    boolean rotate = true;
                    if (ReflectionHelper.isInstanceOf(mobRenderer, "doggytalents.client.entity.render.DogRenderer")) {
                        Optional holder;
                        EntityModel dogModel = null;
                        Optional skin = ReflectionHelper.invokeMethod(entity, "getClientSkin", new Object[0]);
                        if (skin.isPresent() && ReflectionHelper.invokeMethod(skin.get(), "useCustomModel", new Object[0]).orElse(false).booleanValue() && (holder = ReflectionHelper.invokeMethod(skin.get(), "getCustomModel", new Object[0])).isPresent()) {
                            Optional<Object> value = ReflectionHelper.invokeMethod(holder.get(), "getValue", new Object[0]);
                            dogModel = value.orElse(null);
                        }
                        if (dogModel == null && ReflectionHelper.hasField(mobRenderer, "defaultModel")) {
                            dogModel = ReflectionHelper.getPrivateField(mobRenderer, "defaultModel").orElse(null);
                        }
                        if (dogModel != null) {
                            rotate = false;
                            model = dogModel;
                        }
                    }
                    if (ReflectionHelper.hasField(model, "head") && (head = ReflectionHelper.getPrivateField(model, "head")).isPresent()) {
                        Object headPart = head.get();
                        entityIcon = MobIconCache.getIconFromHead((ModelPart)headPart, entityImage, mobLocation, rotate);
                    }
                }
                break block31;
            }
            if (renderer instanceof EnderDragonRenderer) {
                EnderDragonRenderer dragonRenderer = (EnderDragonRenderer)renderer;
                EnderDragonModel model = ((EnderDragonRendererMixin)dragonRenderer).getModel();
                entityIcon = MobIconCache.getIconFromHead(((EnderDragonModelMixin)model).getHead(), entityImage, mobLocation, false);
            }
        }
        if (entityIcon != null && mobLocation != null) {
            String error;
            NativeImage outlined = MobIconCache.generateOutlined(entityIcon);
            ResourceLocation outlinedLocation = mobLocation.withPath(mobLocation.getPath() + OUTLINED_SUFFIX);
            DynamicTexture entityIconTexture = new DynamicTexture(() -> "entity", entityIcon);
            DynamicTexture entityIconTextureOutlined = new DynamicTexture(() -> "entity_outlined", outlined);
            mobsIcons.put(mobLocation, new IconTexture(entityIconTexture, entityIconTextureOutlined));
            Minecraft.getInstance().getTextureManager().register(mobLocation, (AbstractTexture)entityIconTexture);
            Minecraft.getInstance().getTextureManager().register(outlinedLocation, (AbstractTexture)entityIconTexture);
            if (!saveToDisk) return;
            File domainDir = FileHandler.getMobIconsDomainsDirectory(mobLocation);
            File iconFile = new File(domainDir, mobLocation.getPath() + MOB_ICON_FILE_SUFFIX);
            File outlinedFile = new File(domainDir, outlinedLocation.getPath() + MOB_ICON_FILE_SUFFIX);
            try {
                if (!iconFile.exists()) {
                    entityIcon.writeToFile(iconFile);
                }
            }
            catch (IOException e) {
                error = "Could not save icon to file: " + String.valueOf(iconFile) + ": " + e.getMessage();
                Journeymap.getLogger().error(error);
            }
            try {
                if (outlinedFile.exists()) return;
                outlined.writeToFile(outlinedFile);
                return;
            }
            catch (IOException e) {
                error = "Could not save outlined icon to file: " + String.valueOf(outlinedFile) + ": " + e.getMessage();
                Journeymap.getLogger().error(error);
                return;
            }
        }
        mobsIcons.put(mobLocation, null);
    }

    private static NativeImage mergeImages(NativeImage bottomImage, ResourceLocation top) {
        return MobIconCache.mergeImages(bottomImage, top, 0xFFFFFF, 0xFFFFFF);
    }

    private static NativeImage mergeImages(NativeImage bottomImage, ResourceLocation top, int bottomTint, int topTint) {
        NativeImage newImage = null;
        try {
            DynamicTexture topTex = (DynamicTexture)TextureCache.getTexture(top);
            if (topTex == null || !((TextureAccess)topTex).journeymap$hasImage()) {
                return bottomImage;
            }
            NativeImage topImage = topTex.getPixels();
            if (bottomImage.getWidth() != ((TextureAccess)topTex).journeymap$getWidth() || bottomImage.getHeight() != ((TextureAccess)topTex).journeymap$getHeight()) {
                return bottomImage;
            }
            newImage = ImageUtil.getNewBlankImage(bottomImage.getWidth(), bottomImage.getHeight());
            for (int y = 0; y < bottomImage.getHeight(); ++y) {
                for (int x = 0; x < bottomImage.getWidth(); ++x) {
                    int color = topImage.getPixel(x, y);
                    color = (color & 0xFF000000) == 0 ? RGB.tintRgba(bottomImage.getPixel(x, y), bottomTint) : RGB.tintRgba(color, topTint);
                    newImage.setPixel(x, y, color);
                }
            }
            return newImage;
        }
        catch (Exception e) {
            if (newImage != null) {
                newImage.close();
            }
            return bottomImage;
        }
    }

    private static <T extends Entity> ResourceLocation getTextureLocation(EntityRenderer<? super T, ?> renderer, T entity, EntityDTO dto) {
        if (Services.COMMON_SERVICE.isModLoaded("entity_texture_features") && renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer mobRenderer = (LivingEntityRenderer)renderer;
            if (entity instanceof LivingEntity) {
                LivingEntityRenderer livingEntityRenderer = mobRenderer;
                LivingEntityRenderState renderState = (LivingEntityRenderState)livingEntityRenderer.createRenderState();
                livingEntityRenderer.extractRenderState((LivingEntity)entity, renderState, 1.0f);
                return ((LivingEntityRendererETFTextureGetter)mobRenderer).getETFTextureLocation(renderState);
            }
        }
        return dto.entityTextureLocation;
    }

    private static NativeImage getIconFromHead(ModelPart head, NativeImage entityImage, ResourceLocation mobLocation, boolean rotated) {
        if (head == null) {
            return null;
        }
        return MobIconCache.getIconFromHead((Iterable<ModelPart>)ImmutableList.of((Object)head), entityImage, mobLocation, rotated);
    }

    private static NativeImage getIconFromHead(Iterable<ModelPart> heads, NativeImage entityImage, ResourceLocation mobLocation, boolean rotated) {
        if (heads == null) {
            return null;
        }
        ArrayList<ModelPart> fixedHeads = new ArrayList<ModelPart>();
        heads.forEach(head -> ((ModelPartMixin)head).getChildren().forEach((key, part) -> {
            if (key.equals("my_precious")) {
                fixedHeads.add((ModelPart)part);
            } else if (key.equals("real_head")) {
                fixedHeads.add((ModelPart)part);
            }
        }));
        if (!fixedHeads.isEmpty()) {
            heads = fixedHeads;
        }
        HashMap headPoses = new HashMap();
        heads.forEach(head -> headPoses.put(head, head.storePose()));
        heads.forEach(ModelPart::resetPose);
        int scale = 4;
        ArrayList facePolygons = new ArrayList();
        heads.forEach(head -> head.visit(new PoseStack(), (pose, path, i, cube) -> {
            for (ModelPart.Polygon p : cube.polygons) {
                HeadPolygon polygon = new HeadPolygon(pose, p, rotated, 4);
                float epsilon = 1.0E-5f;
                if (!(Math.abs(polygon.normal.z) > epsilon)) continue;
                facePolygons.add(polygon);
            }
        }));
        heads.forEach(head -> head.loadPose((PartPose)headPoses.get(head)));
        if (facePolygons.isEmpty()) {
            return null;
        }
        facePolygons.sort((p1, p2) -> {
            float p2AverageZ = (p2.vertices[0].pos().z + p2.vertices[1].pos().z + p2.vertices[2].pos().z + p2.vertices[3].pos().z) / 4.0f;
            float p1AverageZ = (p1.vertices[0].pos().z + p1.vertices[1].pos().z + p1.vertices[2].pos().z + p1.vertices[3].pos().z) / 4.0f;
            float comp = Math.signum(p2AverageZ - p1AverageZ);
            if (comp == 0.0f) {
                comp = Math.signum(p2.normal.z - p1.normal.z);
            }
            return (int)comp;
        });
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (HeadPolygon p : facePolygons) {
            for (ModelPart.Vertex v : p.vertices) {
                minX = Math.min(minX, Math.round(v.pos().x));
                maxX = Math.max(maxX, Math.round(v.pos().x));
                minY = Math.min(minY, Math.round(v.pos().y));
                maxY = Math.max(maxY, Math.round(v.pos().y));
            }
        }
        int headWidth = maxX - minX;
        int headHeight = maxY - minY;
        NativeImage headImage = ImageUtil.getNewBlankImage((headWidth + 1) * 4, (headHeight + 1) * 4);
        try {
            for (HeadPolygon p : facePolygons) {
                MobIconCache.drawPolygonOnImage(p, minX, minY, entityImage, headImage);
            }
            if ((headImage = MobIconCache.cropImage(headImage)) == null) {
                return null;
            }
            headImage = MobIconCache.resizeImage(headImage, 4, rotated);
            MobIconCache.maskImage(headImage);
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error creating icon for '{}': {}", (Object)mobLocation, (Object)e);
            return null;
        }
        return headImage;
    }

    private static void drawPolygonOnImage(HeadPolygon polygon, int originX, int originY, NativeImage from, NativeImage to) {
        if (polygon.vertices.length != 4) {
            return;
        }
        int texWidth = from.getWidth();
        int texHeight = from.getHeight();
        float minU = texWidth;
        float maxU = 0.0f;
        float minV = texHeight;
        float maxV = 0.0f;
        float minX = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float minY = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        for (ModelPart.Vertex vertex : polygon.vertices) {
            minU = Math.min(minU, vertex.u() * (float)texWidth);
            maxU = Math.max(maxU, vertex.u() * (float)texWidth);
            minV = Math.min(minV, vertex.v() * (float)texHeight);
            maxV = Math.max(maxV, vertex.v() * (float)texHeight);
            minX = Math.min(minX, vertex.pos().x);
            maxX = Math.max(maxX, vertex.pos().x);
            minY = Math.min(minY, vertex.pos().y);
            maxY = Math.max(maxY, vertex.pos().y);
        }
        for (float y = minY; y < maxY; y += 1.0f) {
            for (float x = minX; x < maxX; x += 1.0f) {
                Vector2f uv = MobIconCache.getUVCoordinates(polygon, x, y);
                uv.x = (float)Math.floor(uv.x * (float)texWidth);
                uv.y = (float)Math.floor(uv.y * (float)texHeight);
                if (!(uv.x >= minU) || !(uv.x < maxU) || !(uv.y >= minV) || !(uv.y < maxV)) continue;
                int c = from.getPixel(Math.min(Math.max(0, (int)uv.x), texWidth - 1), Math.min(Math.max(0, (int)uv.y), texHeight - 1));
                if ((c >> 24 & 0xFF) == 255) {
                    to.setPixel(Math.round(x) - originX, Math.round(y) - originY, c);
                    continue;
                }
                if ((c >> 24 & 0xFF) <= 0) continue;
                ((NativeImageAccess)to).blendPixel(Math.round(x) - originX, Math.round(y) - originY, c);
            }
        }
    }

    private static Vector2f getUVCoordinates(HeadPolygon polygon, float x, float y) {
        Vector3f p0 = polygon.vertices[0].pos();
        Vector3f p1 = polygon.vertices[1].pos();
        Vector3f p2 = polygon.vertices[2].pos();
        Vector2f v0 = new Vector2f(p0.x - p2.x, p0.y - p2.y);
        Vector2f v1 = new Vector2f(p1.x - p2.x, p1.y - p2.y);
        Vector2f v2 = new Vector2f(x + 0.5f - p2.x, y + 0.5f - p2.y);
        float den = v0.x * v1.y - v1.x * v0.y;
        float a = (v2.x * v1.y - v1.x * v2.y) / den;
        float b = (v0.x * v2.y - v2.x * v0.y) / den;
        float c = 1.0f - b - a;
        return new Vector2f(a * polygon.vertices[0].u() + b * polygon.vertices[1].u() + c * polygon.vertices[2].u(), a * polygon.vertices[0].v() + b * polygon.vertices[1].v() + c * polygon.vertices[2].v());
    }

    private static NativeImage cropImage(NativeImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int left = width;
        int top = height;
        int right = width;
        int bottom = height;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int c = image.getPixel(x, y);
                if ((c >> 24 & 0xFF) <= 0) continue;
                left = Math.min(left, x);
                top = Math.min(top, y);
                right = Math.min(right, width - x - 1);
                bottom = Math.min(bottom, height - y - 1);
            }
        }
        if (left == width || top == height) {
            image.close();
            return null;
        }
        int newWidth = width - left - right;
        int newHeight = height - top - bottom;
        boolean extraLeft = newWidth % 2 == 1;
        boolean extraBottom = newHeight % 2 == 1;
        NativeImage result = new NativeImage(newWidth + (extraLeft ? 1 : 0), newHeight + (extraBottom ? 1 : 0), false);
        image.copyRect(result, left, top, 0, 0, newWidth, newHeight, false, false);
        image.close();
        if (extraLeft) {
            result.copyRect(result, newWidth - 1, 0, newWidth, 0, 1, newHeight, false, false);
        }
        if (extraBottom) {
            result.copyRect(result, 0, newHeight - 1, 0, newHeight, newWidth + (extraLeft ? 1 : 0), 1, false, false);
        }
        return result;
    }

    private static NativeImage resizeImage(NativeImage image, int scale, boolean rotated) {
        int width = image.getWidth();
        int height = image.getHeight();
        SizeInfo sizeInfo = MobIconCache.getClosestValidSize(width, height, scale);
        CropInfo crop = new CropInfo(0, 0, 0, 0);
        if (!sizeInfo.exact) {
            List<CropInfo> cropsToTry = MobIconCache.getSizesToTry(image, scale, rotated);
            for (CropInfo c : cropsToTry) {
                SizeInfo size = MobIconCache.getClosestValidSize(width - c.left - c.right, height - c.top - c.bottom, scale);
                if (!size.exact) continue;
                sizeInfo = size;
                crop = c;
                break;
            }
        }
        NativeImage result = ImageUtil.getNewBlankImage(sizeInfo.width, sizeInfo.height);
        float finalScale = Math.min((float)sizeInfo.width / (float)(width - crop.left - crop.right), (float)sizeInfo.height / (float)(height - crop.top - crop.bottom));
        for (int y = 0; y < result.getHeight(); ++y) {
            for (int x = 0; x < result.getWidth(); ++x) {
                int fromX = Math.round((float)x / finalScale) + crop.left;
                int fromY = Math.round((float)y / finalScale) + crop.top;
                if (fromX < 0 || fromX >= width || fromY < 0 || fromY >= height) continue;
                result.setPixel(x, y, image.getPixel(fromX, fromY));
            }
        }
        image.close();
        return result;
    }

    private static SizeInfo getClosestValidSize(int width, int height, int scale) {
        if (width == 16 * scale && height == 16 * scale) {
            return new SizeInfo(16, 16, true);
        }
        boolean portrait = height > width;
        int longest = portrait ? height : width;
        int shortest = portrait ? width : height;
        float ratio = (float)longest / (float)shortest;
        int closestL = 16;
        int closestS = 16;
        float closestDist = Math.abs(ratio - 1.0f);
        boolean exact = false;
        for (int l = 14; l <= 22; ++l) {
            int s = Math.round((float)l / ratio);
            int diag = l * l + s * s;
            if (diag < 390 || diag > 650) continue;
            boolean e = l % (longest / scale) == 0 && s % (shortest / scale) == 0;
            float dist = Math.abs(ratio - (float)l / (float)s);
            if (!e && exact || !e && !(dist < closestDist)) continue;
            closestL = l;
            closestS = s;
            exact = e;
        }
        if (portrait) {
            return new SizeInfo(closestS, closestL, exact);
        }
        return new SizeInfo(closestL, closestS, exact);
    }

    private static List<CropInfo> getSizesToTry(NativeImage image, int scale, boolean rotated) {
        int width = image.getWidth();
        int height = image.getHeight();
        boolean portrait = height > width;
        ArrayList<CropInfo> crops = new ArrayList<CropInfo>();
        for (int y = -1; y < 4; ++y) {
            for (int x = -1; x < 4; ++x) {
                if (x == 0 && y == 0) continue;
                if (rotated) {
                    crops.add(new CropInfo(x < 0 ? scale * x : 0, y < 0 ? scale * y : 0, x > 0 ? scale * x : 0, y > 0 ? scale * y : 0));
                    continue;
                }
                crops.add(new CropInfo(scale * x / 2, scale * y / 2, scale * x / 2, scale * y / 2));
            }
        }
        crops.sort((c1, c2) -> {
            int c1H = c1.left + c1.right;
            int c1V = c1.top + c1.bottom;
            int c2H = c2.left + c2.right;
            int c2V = c2.top + c2.bottom;
            int d = c1H + c1V - c2H - c2V;
            if (d == 0) {
                if (portrait && c1V > c1H) {
                    return -1;
                }
                if (!portrait && c1V < c1H) {
                    return 1;
                }
            }
            return d;
        });
        return crops;
    }

    private static void maskImage(NativeImage image) {
        if (markerMask == null) {
            return;
        }
        int cornerX = markerMask.getWidth() / 2 - image.getWidth() / 2;
        int cornerY = markerMask.getHeight() / 2 - image.getHeight() / 2;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if ((markerMask.getPixel(cornerX + x, cornerY + y) & 0xFF000000) != 0) continue;
                image.setPixel(x, y, 0);
            }
        }
    }

    private static NativeImage generateOutlined(NativeImage image) {
        NativeImage outline = ImageUtil.getNewBlankImage(image.getWidth() + 2, image.getHeight() + 2);
        for (int y = -1; y < image.getHeight() + 1; ++y) {
            for (int x = -1; x < image.getWidth() + 1; ++x) {
                if (!MobIconCache.isOpaque(image, x, y)) {
                    boolean opaque = false;
                    opaque = opaque || MobIconCache.isOpaque(image, x - 1, y - 1);
                    opaque = opaque || MobIconCache.isOpaque(image, x + 0, y - 1);
                    opaque = opaque || MobIconCache.isOpaque(image, x + 1, y - 1);
                    opaque = opaque || MobIconCache.isOpaque(image, x - 1, y + 0);
                    opaque = opaque || MobIconCache.isOpaque(image, x + 1, y + 0);
                    opaque = opaque || MobIconCache.isOpaque(image, x - 1, y + 1);
                    opaque = opaque || MobIconCache.isOpaque(image, x + 0, y + 1);
                    boolean bl = opaque = opaque || MobIconCache.isOpaque(image, x + 1, y + 1);
                    if (opaque) {
                        outline.setPixel(x + 1, y + 1, -16777216);
                        continue;
                    }
                }
                if (x < 0 || x >= image.getWidth() || y < 0 || y >= image.getHeight()) continue;
                outline.setPixel(x + 1, y + 1, image.getPixel(x, y));
            }
        }
        return outline;
    }

    private static boolean isOpaque(NativeImage image, int x, int y) {
        if (x < 0 || x >= image.getWidth() || y < 0 || y >= image.getHeight()) {
            return false;
        }
        return (image.getPixel(x, y) & 0xFF000000) != 0;
    }

    private static Optional<ModelPart> getAnyDescendantWithName(ModelPart root, String name) {
        return name.equals("root") ? Optional.of(root) : root.getAllParts().stream().filter(p_365187_ -> p_365187_.hasChild(name)).findFirst().map(p_363155_ -> p_363155_.getChild(name));
    }

    private static class IconTexture {
        public DynamicTexture solid;
        public DynamicTexture outlined;

        public IconTexture() {
            this.solid = null;
            this.outlined = null;
        }

        public IconTexture(DynamicTexture solid, DynamicTexture outlined) {
            this.solid = solid;
            this.outlined = outlined;
        }

        public void remove() {
            if (this.solid != null && ((TextureAccess)this.solid).journeymap$hasImage()) {
                ImageUtil.closeSafely((AbstractTexture)this.solid);
            }
            if (this.outlined != null && ((TextureAccess)this.outlined).journeymap$hasImage()) {
                ImageUtil.closeSafely((AbstractTexture)this.outlined);
            }
        }
    }

    private static class HeadPolygon {
        private static final float PIXEL_TO_BLOCK = 0.0625f;
        private static final float BLOCK_TO_PIXEL = 16.0f;
        public final ModelPart.Vertex[] vertices;
        public final Vector3f normal;

        public HeadPolygon(PoseStack.Pose pose, ModelPart.Polygon polygon, boolean rotated, int scale) {
            int s = scale / 2;
            this.vertices = (ModelPart.Vertex[])polygon.vertices().clone();
            for (int i = 0; i < this.vertices.length; ++i) {
                ModelPart.Vertex v = this.vertices[i];
                Vector4f pos = pose.pose().transform(new Vector4f(v.pos().x * 0.0625f, v.pos().y * 0.0625f, v.pos().z * 0.0625f, 1.0f));
                this.vertices[i] = rotated ? new ModelPart.Vertex((float)(Math.round(pos.z * 16.0f * (float)s) * s), (float)(Math.round(pos.y * 16.0f * (float)s) * s), pos.x * 16.0f * (float)scale, v.u(), v.v()) : new ModelPart.Vertex((float)(Math.round(pos.x * 16.0f * (float)s) * s), (float)(Math.round(pos.y * 16.0f * (float)s) * s), pos.z * 16.0f * (float)scale, v.u(), v.v());
            }
            Vector3f r1 = new Vector3f();
            Vector3f r2 = new Vector3f();
            this.vertices[0].pos().sub((Vector3fc)this.vertices[1].pos(), r1);
            this.vertices[0].pos().sub((Vector3fc)this.vertices[2].pos(), r2);
            this.normal = r1.cross((Vector3fc)r2).normalize();
        }
    }

    private static class SizeInfo {
        public int width;
        public int height;
        public boolean exact;

        public SizeInfo(int width, int height, boolean exact) {
            this.width = width;
            this.height = height;
            this.exact = exact;
        }
    }

    private static class CropInfo {
        public int left;
        public int top;
        public int right;
        public int bottom;

        public CropInfo(int left, int top, int right, int bottom) {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }
    }
}

