/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.List;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class DraggableListPane<T extends Slot>
extends ScrollListPane<T> {
    private boolean clicked = false;
    private Integer frameColor = new Color(-6250336).getRGB();
    private boolean dragging = false;
    private boolean didDrag = false;
    private int mouseDragOffsetX = 0;
    private int mouseDragOffsetY = 0;

    public DraggableListPane(Minecraft mc, int width, int height, int x, int y) {
        super(mc, x, y, width, height, 20);
        super.setX(x);
        super.setY(y);
    }

    @Override
    public void setSlots(List<T> slots) {
        int newWidth = this.width;
        int newHeight = this.height;
        super.setSlots(slots);
        for (Slot slot : this.getRootSlots()) {
            if (!(slot instanceof CategorySlot)) continue;
            newHeight = ((CategorySlot)slot).getAllChildMetadata().size() * 25;
            for (SlotMetadata child : ((CategorySlot)slot).getAllChildMetadata()) {
                String name = child.getName();
                int sWidth = Minecraft.getInstance().font.width(name) * 2;
                newWidth = Math.max(sWidth, newWidth);
            }
        }
        this.updateSize(newWidth, newHeight, 0, super.getY());
    }

    @Override
    public void updateSize(int width, int height, int x, int y) {
        super.setRectangle(width, height, x, y);
        this.listWidth = this.width - this.hpad * 4;
        this.scrollbarX = this.width - this.hpad + super.getX();
    }

    @Override
    protected void renderBackground(GuiGraphics graphics, PoseStack poseStack, int x, int y, float partialTicks) {
        if (this.clicked) {
            graphics.fillGradient(super.getX(), super.getY(), super.getRight(), super.getBottom(), -1072689136, -804253680);
            float alpha = 1.0f;
            DrawUtil.drawRectangle(graphics, super.getX() - 1, super.getY() - 1, this.width + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics, super.getX() - 1, super.getY() + this.height, this.width + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics, super.getX() - 1, super.getY() - 1, 1.0, this.height + 1, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics, this.width + super.getX(), super.getY() - 1, 1.0, this.height + 2, this.frameColor, alpha);
        }
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        boolean paneClicked = false;
        if (super.isMouseOver(pMouseX, pMouseY) && !(this.getEntryAtPosition(pMouseX, pMouseY) instanceof CategorySlot)) {
            paneClicked = super.mouseClicked(pMouseX, pMouseY, pButton);
        } else if (super.isMouseOver(pMouseX, pMouseY) && this.getEntryAtPosition(pMouseX, pMouseY) instanceof CategorySlot) {
            this.mouseDragOffsetX = (int)(pMouseX - (double)super.getX());
            this.mouseDragOffsetY = (int)(pMouseY - (double)super.getY());
            this.dragging = true;
        }
        return paneClicked;
    }

    @Override
    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.dragging) {
            this.didDrag = true;
            int posX = (int)(pMouseX - (double)this.mouseDragOffsetX);
            int posY = (int)(pMouseY - (double)this.mouseDragOffsetY);
            this.updatePosition(posX, posY);
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    protected void renderSelection(GuiGraphics graphics, int top, int width, int height, int outerColor, int innerColor) {
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.dragging && this.didDrag) {
            this.didDrag = false;
            this.dragging = false;
        } else if (super.isMouseOver(mouseX, mouseY) && this.getEntryAtPosition(mouseX, mouseY) instanceof CategorySlot) {
            this.didDrag = false;
            this.dragging = false;
            super.mouseClicked(mouseX, mouseY, mouseButton);
            CategorySlot slot = (CategorySlot)this.getEntryAtPosition(mouseX, mouseY);
            this.clicked = slot.isSelected();
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public void updatePosition(int x, int y) {
        super.setPosition(x, y);
        this.scrollbarX = this.width - this.hpad + super.getX();
        this.listWidth = this.width - this.hpad * 4;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isClicked() {
        return this.clicked;
    }

    public void setClicked(boolean clicked) {
        this.clicked = clicked;
    }
}

