/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.buttons.OnOffButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;

public class SortButton
extends OnOffButton {
    private final String key;
    private boolean sorting = true;

    public SortButton(String message, String key, boolean toggled, Button.OnPress onPress) {
        super(message, message, toggled, onPress);
        this.key = key;
        this.setTextOnly(Minecraft.getInstance().font);
        this.drawUnderline(true);
        this.setWidth(this.width + 5);
        this.setHorizontalAlignment(DrawUtil.HAlign.Right);
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float f) {
        super.renderWidget(graphics, mouseX, mouseY, f);
        if (this.sorting) {
            DrawUtil.drawClampedTexture(graphics, TextureCache.ARROW_GLYPH, this.varLabelColor, 0.8f, this.getX() + this.getFitWidth(Minecraft.getInstance().font) - 5, (float)this.getMiddleY() - 4.0f, 32.0, 32.0, 0.25f, this.toggled != false ? 90.0 : -90.0);
        }
        if (this.isActive()) {
            DrawUtil.drawRectangle(graphics, super.getX(), super.getY() + this.height, this.width, 1.0, this.customFrameColorDark, 1.0f);
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setSorting(boolean sorting) {
        this.sorting = sorting;
    }
}

