/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.popupscreenbutton;

import java.util.function.Supplier;
import journeymap.client.cartography.color.RGB;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ImagePopupButton<T>
extends PopupButton<T> {
    protected final WidgetSprites sprites;
    protected int color = -1;

    public ImagePopupButton(int width, int height, WidgetSprites sprites, Component title, Supplier<PopupButtonScreen<T>> screen, PopupButtonScreen.OnClose<T> onClose) {
        this(width, height, sprites, null, title, screen, onClose);
    }

    public ImagePopupButton(int width, int height, WidgetSprites sprites, @Nullable Integer color, Component title, Supplier<PopupButtonScreen<T>> screen, PopupButtonScreen.OnClose<T> onClose) {
        super(width, height, title, screen, onClose);
        if (color != null) {
            this.color = RGB.toInteger(RGB.floats(color, 255.0f));
        }
        this.sprites = sprites;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        ResourceLocation resourcelocation = this.sprites.get(this.isActive(), this.isHoveredOrFocused());
        TextureCache.getTexture(resourcelocation).setFilter(true, false);
        graphics.blit(RenderPipelines.GUI_TEXTURED, resourcelocation, this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight(), RGB.toArgb(this.color, 1.0f));
    }

    public void renderString(GuiGraphics guiGraphics, Font font, int color) {
    }
}

