/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.widgets;

import java.util.Collection;
import journeymap.client.cartography.color.RGB;
import journeymap.client.ui.component.buttons.RadioButton;
import journeymap.client.ui.component.widgets.RadioButtonListWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.resources.ResourceLocation;

public class ImageRadioButtonListWidget<T extends ResourceLocation>
extends RadioButtonListWidget<T> {
    private final int textureHeight;
    private final int textureWidth;

    public ImageRadioButtonListWidget(String titleKey, Collection<T> values, T enabledValue, int textureWidth, int textureHeight, RadioButtonListWidget.OnChange<T> onChange) {
        super(titleKey, values, enabledValue, onChange);
        this.textureHeight = textureHeight;
        this.textureWidth = textureWidth;
    }

    @Override
    protected RadioButton createRadioButton(T value) {
        return new RadioButton.ImageRadioButton(8, 8, this.textureWidth, this.textureHeight, (ResourceLocation)value, value == this.enabledValue, this::onPress);
    }

    @Override
    protected void buildButtonGrid() {
        this.buttonGrid.rowSpacing(1);
        this.buttonGrid.columnSpacing(-2);
        int row = 0;
        int column = 0;
        for (ResourceLocation value : this.values) {
            if (row >= 4) {
                ++column;
                ++this.columnCt;
                row = 0;
            }
            RadioButton button = this.createRadioButton((T)value);
            this.buttonValueMap.put(button, value);
            LinearLayout layout = LinearLayout.horizontal();
            layout.defaultCellSetting().alignVerticallyMiddle();
            layout.spacing(-4);
            layout.addChild((LayoutElement)button);
            layout.addChild((LayoutElement)((RadioButton.ImageRadioButton)button).getImageWidget());
            this.buttonGrid.addChild((LayoutElement)layout, row++, column);
        }
        this.addChild((LayoutElement)this.buttonGrid, LayoutSettings::alignHorizontallyCenter);
    }

    @Override
    protected void render(GuiGraphics graphics, int mouseX, int mouseY) {
        int startX = this.buttonGrid.getX() - 6 + 1;
        int startY = this.buttonGrid.getY() - 3;
        int width = startX + this.buttonGrid.getWidth() + 12 - 5;
        int height = startY + this.buttonGrid.getHeight() + 6 - 3;
        int color = RGB.DARK_GRAY_RGBA;
        graphics.hLine(startX, width, startY, color);
        graphics.hLine(startX, width, height, color);
        graphics.vLine(startX, startY, height, color);
        graphics.vLine(width, startY, height, color);
    }
}

