/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.widgets;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractStringWidget;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class StringWidget
extends AbstractStringWidget {
    private float alignX = 0.5f;
    private boolean shadow = true;
    private boolean scrolling = false;

    public StringWidget(Component message, Font font) {
        this(message, font.width(message.getVisualOrderText()), font);
    }

    public StringWidget(Component message, int width, Font font) {
        this(0, 0, width, 9, message, font);
    }

    public StringWidget(int width, int height, Component message, Font font) {
        this(0, 0, width, height, message, font);
    }

    public StringWidget(int x, int y, int width, int height, Component message, Font font) {
        super(x, y, width, height, message, font);
        this.active = false;
    }

    public StringWidget setColor(int color) {
        super.setColor(color);
        return this;
    }

    private StringWidget horizontalAlignment(float horizontalAlignment) {
        this.alignX = horizontalAlignment;
        return this;
    }

    public StringWidget scrolling() {
        this.scrolling = true;
        return this;
    }

    public StringWidget noShadow() {
        this.shadow = false;
        return this;
    }

    public StringWidget alignLeft() {
        return this.horizontalAlignment(0.0f);
    }

    public StringWidget alignCenter() {
        return this.horizontalAlignment(0.5f);
    }

    public StringWidget alignRight() {
        return this.horizontalAlignment(1.0f);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Component component = this.getMessage();
        Font font = this.getFont();
        int width = this.getWidth();
        int fontWidth = font.width((FormattedText)component);
        int y = this.getY() + (this.getHeight() - 9) / 2;
        int x = this.getX() + Math.round(this.alignX * (float)(width - fontWidth));
        if (this.scrolling && fontWidth > x + width && this.isHovered()) {
            StringWidget.renderScrollingString((GuiGraphics)guiGraphics, (Font)font, (Component)this.getMessage(), (int)x, (int)y, (int)(x + width), (int)(this.getY() + this.getHeight()), (int)this.getColor());
        } else {
            FormattedCharSequence formattedcharsequence = fontWidth > width ? this.clipText(component, width) : component.getVisualOrderText();
            guiGraphics.drawString(font, formattedcharsequence, x, y, this.getColor(), this.shadow);
        }
    }

    private FormattedCharSequence clipText(Component message, int width) {
        Font font = this.getFont();
        FormattedText formattedtext = font.substrByWidth((FormattedText)message, width - font.width((FormattedText)CommonComponents.ELLIPSIS));
        return Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{formattedtext, CommonComponents.ELLIPSIS}));
    }
}

