/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.option;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.WorldData;
import journeymap.client.log.JMLogger;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.ResetButton;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.OptionScreen;
import journeymap.client.ui.option.OptionSlotFactory;
import journeymap.client.ui.option.OptionsScrollListPane;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.network.model.ServerPropertyType;
import journeymap.common.properties.DefaultDimensionProperties;
import journeymap.common.properties.DimensionProperties;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.ServerCategory;
import journeymap.common.properties.catagory.Category;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ServerOptionsManager
extends OptionScreen {
    protected OptionsScrollListPane<CategorySlot> optionsListPane;
    protected final Map<Category, PropertiesBase> slotMap = Maps.newHashMap();
    private GlobalProperties globalProperties;
    private DefaultDimensionProperties defaultDimensionProperties;
    private final Map<ResourceKey<Level>, DimensionProperties> dimensionPropertyMap = Maps.newHashMap();
    protected Map<Category, List<SlotMetadata>> toolbars;
    protected final List<Category> categoryList;
    private boolean initialized = false;
    private Button buttonSave;

    public ServerOptionsManager(Screen returnDisplay) {
        super(JourneymapClient.getInstance().getStateHandler().canServerAdmin() ? Constants.getString("jm.server.edit.label.admin.edit") : Constants.getString("jm.server.edit.label.admin.read_only"), returnDisplay, false);
        this.categoryList = new ArrayList<Category>(ServerCategory.values);
        this.requestInitData();
    }

    public ServerOptionsManager(Screen returnDisplay, String title, List<Category> categoryList) {
        super(title, returnDisplay, false);
        this.categoryList = categoryList;
        this.requestInitData();
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float par3) {
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        graphics.fillGradient(0, 36, this.width, 70, -1072689136, -804253680);
        try {
            if (this.optionsListPane != null) {
                List lastTooltip = this.optionsListPane.lastTooltip;
                long lastTooltipTime = this.optionsListPane.lastTooltipTime;
                this.optionsListPane.lastTooltip = null;
                this.optionsListPane.render(graphics, x, y, par3);
                super.render(graphics, x, y, par3);
                if (this.optionsListPane.lastTooltip != null && !this.optionsListPane.lastTooltip.equals(lastTooltip)) {
                    this.optionsListPane.lastTooltipTime = lastTooltipTime;
                    if (System.currentTimeMillis() - this.optionsListPane.lastTooltipTime > this.optionsListPane.hoverDelay) {
                        Button button = this.optionsListPane.lastTooltipMetadata.getButton();
                        graphics.setTooltipForNextFrame(this.font, this.optionsListPane.lastTooltip, x, button.getBottomY() + 15);
                    }
                }
            }
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error in OptionsManager.render(): " + String.valueOf(t), t);
        }
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int i, int j, float f) {
    }

    @Override
    protected void layoutButtons(GuiGraphics graphics, PoseStack poseStack) {
        if (this.getRenderables().isEmpty()) {
            this.init();
        }
    }

    @Override
    public void init() {
        if (!this.initialized) {
            this.getRenderables().clear();
            this.specialBottomButtons.clear();
            this.initialized = true;
            this.buttonSave = new Button(Constants.getString("jm.waypoint.save"), b -> {
                this.save();
                this.buttonSave.setEnabled(false);
            });
            this.buttonSave.setEnabled(false);
            boolean canServerAdmin = JourneymapClient.getInstance().getStateHandler().canServerAdmin();
            if (!canServerAdmin) {
                this.buttonSave.setTooltip(Constants.getString("jm.server.button.save.read_only"));
            }
            this.buttonSave.setDefaultStyle(false);
            this.specialBottomButtons.add(this.buttonSave);
            this.addRenderableWidget(this.buttonSave);
        }
        super.init();
        this.buttonServer.setEnabled(false);
        if (this.optionsListPane == null || this.slotMap.size() <= WorldData.getDimensionProviders().size() + 2) {
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            this.optionsListPane = new OptionsScrollListPane(this.minecraft, 0, 70, this.width, this.height - 70 - 30, 20);
            this.optionsListPane.setAlignTop(true);
            List<CategorySlot> categorySlotList = this.getCategorySlotList();
            this.optionsListPane.setSlots(categorySlotList);
        } else {
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            this.optionsListPane.updateSize(this.width, this.height - 70 - 30, 0, 70);
        }
        this.optionsListPane.updateSlots();
    }

    protected List<CategorySlot> getCategorySlotList() {
        return OptionSlotFactory.getOptionSlots(this.getToolbars(), this.slotMap, !JourneymapClient.getInstance().getStateHandler().canServerAdmin(), false);
    }

    protected Map<Category, List<SlotMetadata>> getToolbars() {
        this.toolbars = new HashMap<Category, List<SlotMetadata>>();
        for (Category category : this.categoryList) {
            String name = Constants.getString("jm.config.reset");
            String tooltip = Constants.getString("jm.config.reset.tooltip");
            SlotMetadata toolbarSlotMetadata = new SlotMetadata(new ResetButton(category), name, tooltip);
            this.toolbars.put(category, Collections.singletonList(toolbarSlotMetadata));
        }
        return this.toolbars;
    }

    private void onReset(Category category) {
        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
            if (!category.equals(categorySlot.getCategory())) continue;
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                slotMetadata.resetToDefaultValue();
            }
        }
    }

    protected void requestInitData() {
        this.requestData(ServerPropertyType.GLOBAL.getId(), "");
        this.requestData(ServerPropertyType.DEFAULT.getId(), "");
        WorldData.getDimensionProviders().forEach(dimensionProvider -> this.requestData(ServerPropertyType.DIMENSION.getId(), dimensionProvider.getDimensionId()));
    }

    protected void requestData(int id, String dim) {
        JourneymapClient.getInstance().getDispatcher().sendServerAdminScreenRequest(id, dim);
    }

    public void setData(ServerPropertyType requestType, String payload, String dim) {
        try {
            if (ServerPropertyType.GLOBAL.equals((Object)requestType)) {
                this.globalProperties = (GlobalProperties)new GlobalProperties().loadForClient(payload, false);
                this.slotMap.put(ServerCategory.Global, this.globalProperties);
            }
            if (ServerPropertyType.DEFAULT.equals((Object)requestType)) {
                this.defaultDimensionProperties = (DefaultDimensionProperties)new DefaultDimensionProperties().loadForClient(payload, false);
                this.slotMap.put(ServerCategory.Default, this.defaultDimensionProperties);
            }
            if (ServerPropertyType.DIMENSION.equals((Object)requestType)) {
                DimensionProperties dimensionProperties = (DimensionProperties)new DimensionProperties(dim).loadForClient(payload, false);
                this.dimensionPropertyMap.put(dimensionProperties.getDimension(), dimensionProperties);
                Category category = ServerCategory.create(dim, Constants.getString("jm.server.edit.label.selection.dimension", dim), Constants.getString("jm.server.edit.label.selection.dimension.tooltip"));
                this.categoryList.add(category);
                this.slotMap.put(category, dimensionProperties);
            }
            this.init();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error getting data", (Throwable)e);
        }
    }

    protected void save() {
        this.sendSavePacket(ServerPropertyType.GLOBAL.getId(), this.globalProperties.toJsonString(false), "");
        this.sendSavePacket(ServerPropertyType.DEFAULT.getId(), this.defaultDimensionProperties.toJsonString(false), "");
        this.dimensionPropertyMap.values().forEach(dim -> this.sendSavePacket(ServerPropertyType.DIMENSION.getId(), dim.toJsonString(false), DimensionHelper.getDimKeyName(dim.getDimension())));
    }

    private void sendSavePacket(int id, String payload, String dim) {
        JourneymapClient.getInstance().getDispatcher().sendSaveAdminDataPacket(id, payload, dim);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        try {
            SlotMetadata slotMetadata;
            boolean pressed = this.optionsListPane.mouseClicked(mouseX, mouseY, mouseButton);
            if (pressed && (slotMetadata = this.optionsListPane.getLastPressed()) != null) {
                if (slotMetadata.getButton() instanceof ResetButton) {
                    this.onReset(((ResetButton)slotMetadata.getButton()).category);
                }
                if (!slotMetadata.isToolbar() || slotMetadata.getButton() instanceof ResetButton) {
                    this.buttonSave.setEnabled(true);
                }
            }
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(t.getMessage(), t);
            return false;
        }
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        this.initialized = false;
        super.resize(minecraft, width, height);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.optionsListPane.mouseReleased(mouseX, mouseY, mouseButton);
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        this.optionsListPane.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
        return super.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean mouseScrolled(double x, double y, double f, double scroll) {
        this.optionsListPane.mouseScrolled(x, y, f, scroll);
        return super.mouseScrolled(x, y, f, scroll);
    }
}

