/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.notification;

import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.ScrollListLayoutPane;
import journeymap.client.ui.waypointmanager.notification.WaypointNotificationSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class NotificationPanel<T extends WaypointNotificationSlot>
extends ScrollListLayoutPane<T> {
    final int offset = 1;

    public NotificationPanel(Minecraft mc, int width, int height, int slotHeight) {
        super(mc, 0, 0, width, height, slotHeight);
        this.hpad = 1;
    }

    @Override
    public void updateSize(int width, int height, int x, int y) {
        super.setRectangle(width, height, x - 0, y);
        this.scrollbarX = this.width + x - 1;
        this.listWidth = this.width - 1;
    }

    @Override
    public void setListWidth(int width) {
        this.scrollbarX = (this.width + width) / 2 - 1;
        this.listWidth = width - 1;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.getRootSlots().forEach(slot -> slot.getLayout().visitWidgets(widget -> widget.mouseClicked(mouseX, mouseY, button)));
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        DrawUtil.drawRectangle(graphics, this.getX(), this.getY(), this.width + 4, 1.0, 0x404040, this.alpha);
        DrawUtil.drawRectangle(graphics, this.getX(), this.getY() + this.height, this.width + 4, 1.0, 0x404040, this.alpha);
        DrawUtil.drawRectangle(graphics, this.getX(), this.getY(), 1.0, this.height, 0x404040, this.alpha);
        DrawUtil.drawRectangle(graphics, this.getX() + this.width + 4, this.getY(), 1.0, this.height + 1, 0x404040, this.alpha);
    }

    public void renderSelection(GuiGraphics guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
    }

    public void renderBackground(GuiGraphics graphics, int i, int j, float f) {
    }

    public void setX(int x) {
        super.setX(x);
        this.scrollbarX = this.width + x - 1;
    }
}

