/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.salju.kobolds.client.model.KoboldArmorModel;
import net.salju.kobolds.client.model.SkeleboldModel;
import net.salju.kobolds.client.renderer.AbstractKoboldState;
import net.salju.kobolds.entity.KoboldSkeleton;
import net.salju.kobolds.init.KoboldsClient;

public class KoboldSkeletonRenderer
extends MobRenderer<KoboldSkeleton, AbstractKoboldState, SkeleboldModel<AbstractKoboldState>> {
    public KoboldSkeletonRenderer(EntityRendererProvider.Context context) {
        super(context, new SkeleboldModel(context.bakeLayer(KoboldsClient.SKELEBOLD)), 0.36f);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new KoboldArmorModel(context.bakeLayer(KoboldsClient.KOBOLD_ARMOR_INNER)), (HumanoidModel)new KoboldArmorModel(context.bakeLayer(KoboldsClient.KOBOLD_ARMOR_OUTER)), context.getEquipmentRenderer()));
    }

    public ResourceLocation getTextureLocation(AbstractKoboldState skelebold) {
        return skelebold.texture;
    }

    public AbstractKoboldState createRenderState() {
        return new AbstractKoboldState();
    }

    public void extractRenderState(KoboldSkeleton skelebold, AbstractKoboldState state, float f1) {
        super.extractRenderState((LivingEntity)skelebold, (LivingEntityRenderState)state, f1);
        HumanoidMobRenderer.extractHumanoidRenderState((LivingEntity)skelebold, (HumanoidRenderState)state, (float)f1, (ItemModelResolver)this.itemModelResolver);
        state.texture = ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"textures/entity/undead/skeleton.png");
        state.isAggressive = skelebold.isAggressive();
        state.isCharging = skelebold.isCharging();
        state.isLeftHanded = skelebold.isLeftHanded();
        state.rightStack = skelebold.getItemHeldByArm(HumanoidArm.RIGHT);
        state.leftStack = skelebold.getItemHeldByArm(HumanoidArm.LEFT);
    }

    public void render(AbstractKoboldState skelebold, PoseStack stack, MultiBufferSource buffer, int i) {
        stack.pushPose();
        stack.translate(-0.025, 0.0, 0.0);
        float scale = 0.875f;
        stack.scale(scale, scale, scale);
        super.render((LivingEntityRenderState)skelebold, stack, buffer, i);
        stack.popPose();
    }
}

