/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.salju.kobolds.client.model.KoboldArmorModel;
import net.salju.kobolds.client.model.KoboldModel;
import net.salju.kobolds.client.renderer.AbstractKoboldState;
import net.salju.kobolds.client.renderer.layers.KoboldEyesLayer;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.init.KoboldsClient;

public class KoboldWarriorRenderer
extends MobRenderer<AbstractKoboldEntity, AbstractKoboldState, KoboldModel<AbstractKoboldState>> {
    public KoboldWarriorRenderer(EntityRendererProvider.Context context) {
        super(context, new KoboldModel(context.bakeLayer(KoboldsClient.KOBOLD)), 0.36f);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        this.addLayer((RenderLayer)new KoboldEyesLayer(this));
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new KoboldArmorModel(context.bakeLayer(KoboldsClient.KOBOLD_ARMOR_INNER)), (HumanoidModel)new KoboldArmorModel(context.bakeLayer(KoboldsClient.KOBOLD_ARMOR_OUTER)), context.getEquipmentRenderer()));
    }

    public ResourceLocation getTextureLocation(AbstractKoboldState kobold) {
        return kobold.texture;
    }

    public AbstractKoboldState createRenderState() {
        return new AbstractKoboldState();
    }

    public void extractRenderState(AbstractKoboldEntity kobold, AbstractKoboldState state, float f1) {
        super.extractRenderState((LivingEntity)kobold, (LivingEntityRenderState)state, f1);
        HumanoidMobRenderer.extractHumanoidRenderState((LivingEntity)kobold, (HumanoidRenderState)state, (float)f1, (ItemModelResolver)this.itemModelResolver);
        if (kobold.getName().getString().equals("Popper")) {
            state.texture = ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"textures/entity/special/popper.png");
            state.isPopper = true;
        } else {
            state.texture = ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"textures/entity/kobolds/warrior.png");
        }
        state.isAggressive = kobold.isAggressive();
        state.isBlocking = kobold.isBlocking();
        state.isCharging = kobold.isCharging();
        state.isDiamond = kobold.isDiamond();
        state.isLeftHanded = kobold.isLeftHanded();
        state.rightStack = kobold.getItemHeldByArm(HumanoidArm.RIGHT);
        state.leftStack = kobold.getItemHeldByArm(HumanoidArm.LEFT);
    }

    public void render(AbstractKoboldState kobold, PoseStack stack, MultiBufferSource buffer, int i) {
        stack.pushPose();
        stack.translate(-0.025, 0.0, 0.0);
        float scale = 0.875f;
        stack.scale(scale, scale, scale);
        super.render((LivingEntityRenderState)kobold, stack, buffer, i);
        stack.popPose();
    }
}

