/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity.ai;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.salju.kobolds.Kobolds;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.init.KoboldsSounds;

public class KoboldTradeGoal
extends Goal {
    public final AbstractKoboldEntity kobold;
    public final String loc;

    public KoboldTradeGoal(AbstractKoboldEntity kobold, String str) {
        this.kobold = kobold;
        this.loc = str;
    }

    public boolean canUse() {
        return this.isHoldingGem();
    }

    public void start() {
        this.kobold.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 120, 10, false, false));
        Kobolds.queueServerWork(100, () -> {
            if (this.kobold.isAlive()) {
                InteractionHand hand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.kobold, item -> new ItemStack((ItemLike)item).is(Items.EMERALD));
                this.kobold.swing(hand.equals((Object)InteractionHand.OFF_HAND) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, true);
                this.kobold.playSound((SoundEvent)KoboldsSounds.KOBOLD_TRADE.get(), 1.0f, 1.0f);
                Level patt0$temp = this.kobold.level();
                if (patt0$temp instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)patt0$temp;
                    List<ItemStack> list = AbstractKoboldEntity.getTradeItems(this.kobold, this.loc);
                    Vec3 pos = LandRandomPos.getPos((PathfinderMob)this.kobold, (int)2, (int)1);
                    Player target = lvl.getNearestPlayer((Entity)this.kobold, 7.0);
                    if (target != null) {
                        pos = target.position();
                    } else if (pos == null) {
                        pos = this.kobold.position();
                    }
                    for (ItemStack stack : list) {
                        BehaviorUtils.throwItem((LivingEntity)this.kobold, (ItemStack)stack, (Vec3)pos);
                    }
                }
                Kobolds.queueServerWork(20, () -> {
                    if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
                        this.kobold.setItemInHand(hand, this.kobold.getOffhandItem().getItem() instanceof TridentItem ? ItemStack.EMPTY : this.kobold.getPrimary());
                    } else {
                        this.kobold.setItemInHand(hand, this.kobold.getSecondary().getItem() instanceof TridentItem ? ItemStack.EMPTY : this.kobold.getSecondary());
                    }
                });
            }
        });
    }

    private boolean isHoldingGem() {
        return this.kobold.isHolding(Items.EMERALD);
    }
}

