/*
 * Decompiled with CFR 0.152.
 */
package baguchi.hunters_return.client.render;

import baguchi.bagus_lib.client.layer.CustomArmorLayer;
import baguchi.hunters_return.HunterConfig;
import baguchi.hunters_return.client.ModModelLayers;
import baguchi.hunters_return.client.model.HunterModel;
import baguchi.hunters_return.client.model.NewHunterModel;
import baguchi.hunters_return.client.model.OldHunterModel;
import baguchi.hunters_return.client.render.layer.MouthItemLayer;
import baguchi.hunters_return.client.render.state.HunterRenderState;
import baguchi.hunters_return.entity.Hunter;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractIllager;

public class HunterRender
extends MobRenderer<Hunter, HunterRenderState, HunterModel<HunterRenderState>> {
    private static final ResourceLocation ILLAGER = ResourceLocation.fromNamespaceAndPath((String)"hunters_return", (String)"textures/entity/hunter/hunter.png");
    private static final ResourceLocation ILLAGER_OLD = ResourceLocation.fromNamespaceAndPath((String)"hunters_return", (String)"textures/entity/hunter/normal_old.png");
    private static final RenderType SLEEP_EYE = RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hunters_return", (String)"textures/entity/hunter/sleep_eye.png"));
    private static final RenderType SLEEP_EYE_OLD = RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hunters_return", (String)"textures/entity/hunter/sleep_eye_old.png"));
    private final HunterModel<HunterRenderState> old;
    private final HunterModel<HunterRenderState> normal;

    public HunterRender(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, new NewHunterModel(renderManagerIn.bakeLayer(ModModelLayers.HUNTER)), 0.5f);
        this.addLayer((RenderLayer)new CustomArmorLayer((RenderLayerParent)this, renderManagerIn));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        this.addLayer(new MouthItemLayer(this));
        this.addLayer((RenderLayer)new EyesLayer<HunterRenderState, HunterModel<HunterRenderState>>(this, (RenderLayerParent)this){

            public void render(PoseStack p_116983_, MultiBufferSource p_116984_, int p_116985_, HunterRenderState p_363277_, float p_116987_, float p_116988_) {
                float f3 = p_363277_.ageInTicks + (float)p_363277_.id;
                if (!p_363277_.isInvisible && (0.0 > Math.sin(f3 * 0.05f) + Math.sin(f3 * 0.13f) + Math.sin(f3 * 0.7f) + (double)2.55f || p_363277_.sleep)) {
                    super.render(p_116983_, p_116984_, p_116985_, (EntityRenderState)p_363277_, p_116987_, p_116988_);
                }
            }

            public RenderType renderType() {
                if (((Boolean)HunterConfig.CLIENT.oldModel.get()).booleanValue()) {
                    return SLEEP_EYE_OLD;
                }
                return SLEEP_EYE;
            }
        });
        this.old = new OldHunterModel<HunterRenderState>(renderManagerIn.bakeLayer(ModModelLayers.HUNTER_OLD));
        this.normal = new NewHunterModel<HunterRenderState>(renderManagerIn.bakeLayer(ModModelLayers.HUNTER));
    }

    public void render(HunterRenderState p_361886_, PoseStack p_115311_, MultiBufferSource p_115312_, int p_115313_) {
        super.render((LivingEntityRenderState)p_361886_, p_115311_, p_115312_, p_115313_);
        this.model = (Boolean)HunterConfig.CLIENT.oldModel.get() != false ? this.old : this.normal;
    }

    public HunterRenderState createRenderState() {
        return new HunterRenderState();
    }

    public void extractRenderState(Hunter hunter, HunterRenderState hunterState, float p_361157_) {
        super.extractRenderState((LivingEntity)hunter, (LivingEntityRenderState)hunterState, p_361157_);
        ArmedEntityRenderState.extractArmedEntityRenderState((LivingEntity)hunter, (ArmedEntityRenderState)hunterState, (ItemModelResolver)this.itemModelResolver);
        HunterRenderState.extractMouthEntityRenderState(hunter, hunterState, this.itemModelResolver);
        hunterState.isRiding = hunter.isPassenger();
        hunterState.mainArm = hunter.getMainArm();
        hunterState.armPose = hunter.getArmPose();
        hunterState.maxCrossbowChargeDuration = hunterState.armPose == AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE ? hunter.getUseItem().getUseDuration((LivingEntity)hunter) : 0;
        hunterState.ticksUsingItem = hunter.getTicksUsingItem();
        hunterState.attackAnim = hunter.getAttackAnim(p_361157_);
        hunterState.isAggressive = hunter.isAggressive();
        hunterState.attackAnimationState.copyFrom(hunter.attackAnimationState);
        hunterState.chargeAnimationState.copyFrom(hunter.chargeAnimationState);
        hunterState.shootAnimationState.copyFrom(hunter.shootAnimationState);
        hunterState.thrownAnimationState.copyFrom(hunter.thrownAnimationState);
        hunterState.dodghRightAnimationState.copyFrom(hunter.dodghRightAnimationState);
        hunterState.dodghLeftAnimationState.copyFrom(hunter.dodghLeftAnimationState);
        hunterState.texture = hunter.getTexture();
        hunterState.textureOld = hunter.getTextureOld();
        hunterState.eyeRot = hunter.getViewYRot(p_361157_) - hunter.getPreciseBodyRotation(p_361157_) + 180.0f;
        hunterState.sleep = hunter.isSleeping();
        hunterState.id = hunter.getId();
    }

    public ResourceLocation getTextureLocation(HunterRenderState hunterRenderState) {
        if (((Boolean)HunterConfig.CLIENT.oldModel.get()).booleanValue()) {
            if (hunterRenderState.textureOld != null) {
                return hunterRenderState.textureOld;
            }
            return ILLAGER_OLD;
        }
        if (hunterRenderState.texture != null) {
            return hunterRenderState.texture;
        }
        return ILLAGER;
    }
}

