/*
 * Decompiled with CFR 0.152.
 */
package baguchi.hunters_return.entity.ai;

import baguchi.hunters_return.entity.Hunter;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.projectile.Projectile;

public class DodgeGoal
extends Goal {
    public final Hunter hunter;
    @Nullable
    protected List<? extends Projectile> toAvoid;
    protected final Class<? extends Projectile> dodgeAtType;
    protected final TargetingConditions lookAtContext;
    private int cooldownTime;
    private int dodgeTime;
    private boolean dodgeDirection;

    public DodgeGoal(Hunter hunterEntity) {
        this.hunter = hunterEntity;
        this.dodgeAtType = Projectile.class;
        this.lookAtContext = TargetingConditions.forNonCombat().range(10.0);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (--this.cooldownTime < 0 && this.hunter.getTarget() != null) {
            this.toAvoid = this.hunter.level().getEntitiesOfClass(this.dodgeAtType, this.hunter.getBoundingBox().inflate(10.0, 5.0, 10.0), p_148124_ -> p_148124_.getOwner() == this.hunter.getTarget() && (p_148124_.getOwner() == null || !this.hunter.isAlliedTo(p_148124_.getOwner())));
            if (!this.toAvoid.isEmpty()) {
                this.cooldownTime = 20 + this.hunter.getRandom().nextInt(2) * 10;
                return true;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.dodgeTime > 0;
    }

    public void start() {
        super.start();
        this.dodgeTime = 8;
        this.dodgeDirection = this.hunter.getRandom().nextBoolean();
        if (this.dodgeDirection) {
            this.hunter.level().broadcastEntityEvent((Entity)this.hunter, (byte)64);
        } else {
            this.hunter.level().broadcastEntityEvent((Entity)this.hunter, (byte)65);
        }
    }

    public void tick() {
        super.tick();
        --this.dodgeTime;
        this.hunter.setXxa(this.dodgeDirection ? 1.0f : -1.0f);
        if (this.hunter.getTarget() != null) {
            this.hunter.getLookControl().setLookAt((Entity)this.hunter.getTarget(), 30.0f, 30.0f);
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void stop() {
        super.stop();
        this.hunter.setXxa(0.0f);
        this.cooldownTime = 40 + this.hunter.getRandom().nextInt(2) * 20;
    }
}

