/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity;

import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.EnergyPipeType;
import de.maxhenkel.pipez.blocks.tileentity.types.FluidPipeType;
import de.maxhenkel.pipez.blocks.tileentity.types.ItemPipeType;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.utils.DummyFluidHandler;
import de.maxhenkel.pipez.utils.DummyItemHandler;
import de.maxhenkel.pipez.utils.PipeEnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;

public abstract class PipeLogicTileEntity
extends UpgradeTileEntity {
    protected PipeType<?, ?>[] types;
    protected final int[][] rrIndex;
    protected PipeEnergyStorage[] energyStorages;
    private int recursionDepth;

    public PipeLogicTileEntity(BlockEntityType<?> tileEntityTypeIn, PipeType<?, ?>[] types, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.types = types;
        this.rrIndex = new int[Direction.values().length][types.length];
        this.energyStorages = new PipeEnergyStorage[Direction.values().length];
    }

    @Nullable
    public <T> T onRegisterCapability(BlockCapability<T, Direction> capability, @Nullable Direction side) {
        if (side == null) {
            return null;
        }
        if (!this.isExtracting(side)) {
            return null;
        }
        if (capability == Capabilities.EnergyStorage.BLOCK && this.hasType(EnergyPipeType.INSTANCE)) {
            if (side != null) {
                if (this.energyStorages[side.get3DDataValue()] == null) {
                    this.energyStorages[side.get3DDataValue()] = new PipeEnergyStorage(this, side);
                }
                return (T)this.energyStorages[side.get3DDataValue()];
            }
        } else if (capability == Capabilities.FluidHandler.BLOCK && this.hasType(FluidPipeType.INSTANCE)) {
            if (side != null) {
                return (T)DummyFluidHandler.INSTANCE;
            }
        } else if (capability == Capabilities.ItemHandler.BLOCK && this.hasType(ItemPipeType.INSTANCE) && side != null) {
            return (T)DummyItemHandler.INSTANCE;
        }
        return null;
    }

    public boolean hasType(PipeType<?, ?> type) {
        for (PipeType<?, ?> t : this.types) {
            if (t != type) continue;
            return true;
        }
        return false;
    }

    public int getRoundRobinIndex(Direction direction, PipeType<?, ?> pipeType) {
        return this.rrIndex[direction.get3DDataValue()][this.getIndex(pipeType)];
    }

    public void setRoundRobinIndex(Direction direction, PipeType<?, ?> pipeType, int value) {
        this.rrIndex[direction.get3DDataValue()][this.getIndex(pipeType)] = value;
    }

    public boolean isEnabled(Direction side, PipeType<?, ?> pipeType) {
        UpgradeTileEntity.RedstoneMode redstoneMode = this.getRedstoneMode(side, pipeType);
        return redstoneMode != UpgradeTileEntity.RedstoneMode.ALWAYS_OFF;
    }

    public int getPreferredPipeIndex(Direction side) {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.isEnabled(side, this.types[i])) continue;
            return i;
        }
        return 0;
    }

    public boolean shouldWork(Direction side, PipeType<?, ?> pipeType) {
        UpgradeTileEntity.RedstoneMode redstoneMode = this.getRedstoneMode(side, pipeType);
        if (redstoneMode.equals(UpgradeTileEntity.RedstoneMode.ALWAYS_OFF)) {
            return false;
        }
        if (redstoneMode.equals(UpgradeTileEntity.RedstoneMode.OFF_WHEN_POWERED)) {
            return !this.isRedstonePowered();
        }
        if (redstoneMode.equals(UpgradeTileEntity.RedstoneMode.ON_WHEN_POWERED)) {
            return this.isRedstonePowered();
        }
        return true;
    }

    public boolean isRedstonePowered() {
        return this.level.hasNeighborSignal(this.worldPosition);
    }

    public PipeType<?, ?>[] getPipeTypes() {
        return this.types;
    }

    public int getIndex(PipeType<?, ?> pipeType) {
        for (int i = 0; i < this.getPipeTypes().length; ++i) {
            PipeType<?, ?> type = this.getPipeTypes()[i];
            if (type != pipeType) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            return;
        }
        for (PipeType<?, ?> pipeType : this.getPipeTypes()) {
            pipeType.tick(this);
        }
        if (this.hasType(EnergyPipeType.INSTANCE)) {
            for (PipeType<?, ?> pipeType : Direction.values()) {
                if (!this.isExtracting((Direction)pipeType) || this.energyStorages[pipeType.get3DDataValue()] == null) continue;
                this.energyStorages[pipeType.get3DDataValue()].tick();
            }
        }
    }

    public void invalidateCapabilities() {
        if (this.level != null) {
            this.level.invalidateCapabilities(this.worldPosition);
        }
        if (!this.hasType(EnergyPipeType.INSTANCE)) {
            return;
        }
        for (Direction dir : Direction.values()) {
            if (this.isExtracting(dir)) continue;
            this.energyStorages[dir.get3DDataValue()] = null;
        }
    }

    @Override
    public void setExtracting(Direction side, boolean extracting) {
        super.setExtracting(side, extracting);
        this.invalidateCapabilities();
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.invalidateCapabilities();
    }

    public void setRemoved() {
        this.invalidateCapabilities();
        super.setRemoved();
    }

    @Override
    public boolean canInsert(Level level, PipeTileEntity.Connection connection) {
        for (PipeType<?, ?> type : this.types) {
            for (BlockCapability<?, Direction> provider : type.getCapabilities()) {
                if (connection.getCapability(provider) == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean pushRecursion() {
        if (this.recursionDepth >= 1) {
            return true;
        }
        ++this.recursionDepth;
        return false;
    }

    public void popRecursion() {
        --this.recursionDepth;
    }
}

