/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity;

import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.blocks.PipeBlock;
import de.maxhenkel.pipez.capabilities.ModCapabilities;
import de.maxhenkel.pipez.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.pipez.corelib.codec.ValueInputOutputUtils;
import de.maxhenkel.pipez.utils.MekanismUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class PipeTileEntity
extends BlockEntity
implements ITickableBlockEntity {
    @Nullable
    protected List<Connection> connectionCache;
    @Nullable
    protected Connection[] extractingConnectionCache;
    protected boolean[] extractingSides = new boolean[Direction.values().length];
    protected boolean[] disconnectedSides = new boolean[Direction.values().length];
    private int invalidateCountdown;

    public PipeTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public List<Connection> getConnections() {
        if (this.level == null) {
            return new ArrayList<Connection>();
        }
        if (this.connectionCache == null) {
            this.updateConnectionCache();
            if (this.connectionCache == null) {
                return new ArrayList<Connection>();
            }
        }
        return this.connectionCache;
    }

    @Nullable
    public Connection getExtractingConnection(Direction side) {
        if (this.level == null) {
            return null;
        }
        if (this.extractingConnectionCache == null) {
            this.updateExtractingConnectionCache();
            if (this.extractingConnectionCache == null) {
                return null;
            }
        }
        return this.extractingConnectionCache[side.get3DDataValue()];
    }

    public static void markPipesDirty(Level world, BlockPos pos) {
        ArrayList<BlockPos> travelPositions = new ArrayList<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        Block block = world.getBlockState(pos).getBlock();
        if (!(block instanceof PipeBlock)) {
            return;
        }
        PipeBlock pipeBlock = (PipeBlock)block;
        PipeTileEntity pipeTe = pipeBlock.getTileEntity((LevelAccessor)world, pos);
        if (pipeTe != null) {
            for (Direction side : Direction.values()) {
                if (!pipeTe.isExtracting(side) || pipeBlock.canConnectTo(world, pos, side)) continue;
                pipeTe.setExtracting(side, false);
                if (!pipeTe.hasReasonToStay()) {
                    pipeBlock.setHasData(world, pos, false);
                }
                pipeTe.syncData();
            }
        }
        travelPositions.add(pos);
        PipeTileEntity.addToDirtyList(world, pos, pipeBlock, travelPositions, queue);
        while (queue.size() > 0) {
            BlockPos blockPos = queue.removeFirst();
            block = world.getBlockState(blockPos).getBlock();
            if (!(block instanceof PipeBlock)) continue;
            PipeTileEntity.addToDirtyList(world, blockPos, (PipeBlock)block, travelPositions, queue);
        }
        for (BlockPos p : travelPositions) {
            BlockEntity te = world.getBlockEntity(p);
            if (!(te instanceof PipeTileEntity)) continue;
            PipeTileEntity pipe = (PipeTileEntity)te;
            pipe.connectionCache = null;
        }
    }

    private static void addToDirtyList(Level world, BlockPos pos, PipeBlock pipeBlock, List<BlockPos> travelPositions, LinkedList<BlockPos> queue) {
        for (Direction direction : Direction.values()) {
            BlockPos p;
            if (!pipeBlock.isConnected(world, pos, direction) || travelPositions.contains(p = pos.relative(direction)) || queue.contains(p)) continue;
            travelPositions.add(p);
            queue.add(p);
        }
    }

    private void updateConnectionCache() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            this.connectionCache = null;
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockState blockState = this.getBlockState();
        if (!(blockState.getBlock() instanceof PipeBlock)) {
            this.connectionCache = null;
            return;
        }
        if (!this.isExtracting()) {
            this.connectionCache = null;
            return;
        }
        HashMap<DirectionalPosition, Connection> connections = new HashMap<DirectionalPosition, Connection>();
        HashMap<BlockPos, Integer> queue = new HashMap<BlockPos, Integer>();
        ArrayList<BlockPos> travelPositions = new ArrayList<BlockPos>();
        this.addToQueue(serverLevel, this.worldPosition, queue, travelPositions, connections, 1);
        while (queue.size() > 0) {
            Map.Entry blockPosIntegerEntry = (Map.Entry)queue.entrySet().stream().findAny().get();
            this.addToQueue(serverLevel, (BlockPos)blockPosIntegerEntry.getKey(), queue, travelPositions, connections, (Integer)blockPosIntegerEntry.getValue());
            travelPositions.add((BlockPos)blockPosIntegerEntry.getKey());
            queue.remove(blockPosIntegerEntry.getKey());
        }
        this.connectionCache = new ArrayList(connections.values());
    }

    private void updateExtractingConnectionCache() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            this.connectionCache = null;
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockState blockState = this.getBlockState();
        if (!(blockState.getBlock() instanceof PipeBlock)) {
            this.extractingConnectionCache = null;
            return;
        }
        this.extractingConnectionCache = new Connection[Direction.values().length];
        for (Direction direction : Direction.values()) {
            this.extractingConnectionCache[direction.get3DDataValue()] = !this.isExtracting(direction) ? null : new Connection(serverLevel, this.getBlockPos().relative(direction), direction.getOpposite(), 1);
        }
    }

    public void addToQueue(ServerLevel world, BlockPos position, Map<BlockPos, Integer> queue, List<BlockPos> travelPositions, Map<DirectionalPosition, Connection> insertPositions, int distance) {
        Block block = world.getBlockState(position).getBlock();
        if (!(block instanceof PipeBlock)) {
            return;
        }
        PipeBlock pipeBlock = (PipeBlock)block;
        for (Direction direction : Direction.values()) {
            if (!pipeBlock.isConnected((Level)world, position, direction)) continue;
            BlockPos p = position.relative(direction);
            DirectionalPosition dp = new DirectionalPosition(p, direction.getOpposite());
            Connection connection = new Connection(world, dp.getPos(), dp.getDirection(), distance);
            if (!this.isExtracting(this.level, position, direction) && this.canInsert(this.level, connection)) {
                if (!insertPositions.containsKey(dp)) {
                    insertPositions.put(dp, connection);
                    continue;
                }
                if (insertPositions.get(dp).getDistance() <= distance) continue;
                insertPositions.put(dp, connection);
                continue;
            }
            if (travelPositions.contains(p) || queue.containsKey(p)) continue;
            queue.put(p, distance + 1);
        }
    }

    private boolean isExtracting(Level level, BlockPos pos, Direction direction) {
        PipeTileEntity pipe;
        BlockEntity te = level.getBlockEntity(pos);
        return te instanceof PipeTileEntity && (pipe = (PipeTileEntity)te).isExtracting(direction);
    }

    public abstract boolean canInsert(Level var1, Connection var2);

    @Override
    public void tick() {
        if (this.invalidateCountdown >= 0) {
            --this.invalidateCountdown;
            if (this.invalidateCountdown <= 0) {
                this.connectionCache = null;
            }
        }
    }

    public boolean isExtracting(Direction side) {
        return this.extractingSides[side.get3DDataValue()];
    }

    public boolean isExtracting() {
        for (boolean extract : this.extractingSides) {
            if (!extract) continue;
            return true;
        }
        return false;
    }

    public boolean hasReasonToStay() {
        if (this.isExtracting()) {
            return true;
        }
        for (boolean disconnected : this.disconnectedSides) {
            if (!disconnected) continue;
            return true;
        }
        return false;
    }

    public void setExtracting(Direction side, boolean extracting) {
        this.extractingSides[side.get3DDataValue()] = extracting;
        this.extractingConnectionCache = null;
        this.setChanged();
    }

    public boolean isDisconnected(Direction side) {
        return this.disconnectedSides[side.get3DDataValue()];
    }

    public void setDisconnected(Direction side, boolean disconnected) {
        this.disconnectedSides[side.get3DDataValue()] = disconnected;
        this.setChanged();
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.extractingSides = new boolean[Direction.values().length];
        CompoundTag tag = ValueInputOutputUtils.getTag(valueInput);
        Optional extractingList = tag.getList("ExtractingSides");
        if (extractingList.isPresent() && ((ListTag)extractingList.get()).size() >= this.extractingSides.length) {
            for (int i = 0; i < this.extractingSides.length; ++i) {
                Optional optionalByte = ((ListTag)extractingList.get()).get(i).asByte();
                if (!optionalByte.isPresent()) continue;
                this.extractingSides[i] = (Byte)optionalByte.get() != 0;
            }
        }
        this.disconnectedSides = new boolean[Direction.values().length];
        Optional disconnectedList = tag.getList("DisconnectedSides");
        if (disconnectedList.isPresent() && ((ListTag)disconnectedList.get()).size() >= this.disconnectedSides.length) {
            for (int i = 0; i < this.disconnectedSides.length; ++i) {
                Optional optionalByte = ((ListTag)disconnectedList.get()).get(i).asByte();
                if (!optionalByte.isPresent()) continue;
                this.disconnectedSides[i] = (Byte)optionalByte.get() != 0;
            }
        }
        this.invalidateCountdown = 10;
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        CompoundTag tag = new CompoundTag();
        ListTag extractingList = new ListTag();
        for (boolean extractingSide : this.extractingSides) {
            extractingList.add((Object)ByteTag.valueOf((boolean)extractingSide));
        }
        tag.put("ExtractingSides", (Tag)extractingList);
        ListTag disconnectedList = new ListTag();
        for (boolean disconnected : this.disconnectedSides) {
            disconnectedList.add((Object)ByteTag.valueOf((boolean)disconnected));
        }
        tag.put("DisconnectedSides", (Tag)disconnectedList);
        valueOutput.store(tag);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void syncData(ServerPlayer player) {
        player.connection.send(this.getUpdatePacket());
    }

    public void syncData() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        LevelChunk chunk = this.level.getChunkAt(this.getBlockPos());
        ((ServerChunkCache)this.level.getChunkSource()).chunkMap.getPlayers(chunk.getPos(), false).forEach(e -> e.connection.send(this.getUpdatePacket()));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getUpdateTag(provider);
        TagValueOutput valueOutput = ValueInputOutputUtils.createValueOutput(this, provider);
        this.saveAdditional((ValueOutput)valueOutput);
        updateTag.merge(ValueInputOutputUtils.toTag(valueOutput));
        return updateTag;
    }

    public static class Connection {
        private final BlockPos pos;
        private final Direction direction;
        private final int distance;
        private BlockCapabilityCache<IItemHandler, Direction> itemHandler;
        private BlockCapabilityCache<IEnergyStorage, Direction> energyHandler;
        private BlockCapabilityCache<IFluidHandler, Direction> fluidHandler;
        private Optional<BlockCapabilityCache<IChemicalHandler, Direction>> chemicalHandler;

        public Connection(ServerLevel level, BlockPos pos, Direction direction, int distance) {
            this.pos = pos;
            this.direction = direction;
            this.distance = distance;
            this.itemHandler = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)level, (BlockPos)pos, (Object)direction);
            this.energyHandler = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)level, (BlockPos)pos, (Object)direction);
            this.fluidHandler = BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)level, (BlockPos)pos, (Object)direction);
            this.chemicalHandler = MekanismUtils.isMekanismInstalled() ? Optional.of(BlockCapabilityCache.create(ModCapabilities.CHEMICAL_HANDLER_CAPABILITY, (ServerLevel)level, (BlockPos)pos, (Object)direction)) : Optional.empty();
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public int getDistance() {
            return this.distance;
        }

        public String toString() {
            return "Connection{pos=" + String.valueOf(this.pos) + ", direction=" + String.valueOf(this.direction) + ", distance=" + this.distance + "}";
        }

        @Nullable
        public IItemHandler getItemHandler() {
            return (IItemHandler)this.itemHandler.getCapability();
        }

        @Nullable
        public IEnergyStorage getEnergyHandler() {
            return (IEnergyStorage)this.energyHandler.getCapability();
        }

        @Nullable
        public IFluidHandler getFluidHandler() {
            return (IFluidHandler)this.fluidHandler.getCapability();
        }

        @Nullable
        public IChemicalHandler getChemicalHandler() {
            return this.chemicalHandler.map(BlockCapabilityCache::getCapability).orElse(null);
        }

        @Nullable
        public <T> T getCapability(BlockCapability<T, Direction> capability) {
            if (capability == Capabilities.ItemHandler.BLOCK) {
                return (T)this.getItemHandler();
            }
            if (capability == Capabilities.EnergyStorage.BLOCK) {
                return (T)this.getEnergyHandler();
            }
            if (capability == Capabilities.FluidHandler.BLOCK) {
                return (T)this.getFluidHandler();
            }
            if (!MekanismUtils.isMekanismInstalled()) {
                return null;
            }
            if (capability == ModCapabilities.CHEMICAL_HANDLER_CAPABILITY) {
                return (T)this.getChemicalHandler();
            }
            return null;
        }
    }
}

