/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.configuration.DistributionCache;
import de.maxhenkel.pipez.blocks.tileentity.configuration.FilterCache;
import de.maxhenkel.pipez.blocks.tileentity.configuration.FilterModeCache;
import de.maxhenkel.pipez.blocks.tileentity.configuration.RedstoneModeCache;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.corelib.inventory.ItemListInventory;
import de.maxhenkel.pipez.corelib.item.ItemUtils;
import de.maxhenkel.pipez.items.UpgradeItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class UpgradeTileEntity
extends PipeTileEntity {
    protected final NonNullList<ItemStack> upgradeInventory = NonNullList.withSize((int)Direction.values().length, (Object)ItemStack.EMPTY);
    protected final ItemListInventory inventory = new ItemListInventory(this.upgradeInventory, this::invalidateAllCaches);
    protected RedstoneModeCache redstoneModes;
    protected DistributionCache distributions;
    protected FilterModeCache filterModes;
    protected FilterCache filters;

    public UpgradeTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.initCaches();
    }

    public void initCaches() {
        this.redstoneModes = new RedstoneModeCache(() -> this.upgradeInventory, PipeType::getDefaultRedstoneMode, this::invalidateAllCaches);
        this.distributions = new DistributionCache(() -> this.upgradeInventory, PipeType::getDefaultDistribution, this::invalidateAllCaches);
        this.filterModes = new FilterModeCache(() -> this.upgradeInventory, PipeType::getDefaultFilterMode, this::invalidateAllCaches);
        this.filters = new FilterCache(() -> this.upgradeInventory, this::invalidateAllCaches);
    }

    public void invalidateAllCaches() {
        this.redstoneModes.invalidate();
        this.distributions.invalidate();
        this.filterModes.invalidate();
        this.filters.invalidate();
        this.setChanged();
    }

    public ItemStack setUpgradeItem(Direction side, ItemStack upgrade) {
        ItemStack old = (ItemStack)this.upgradeInventory.get(side.get3DDataValue());
        this.upgradeInventory.set(side.get3DDataValue(), (Object)upgrade);
        this.invalidateAllCaches();
        return old;
    }

    public ItemStack getUpgradeItem(Direction side) {
        return (ItemStack)this.upgradeInventory.get(side.get3DDataValue());
    }

    public RedstoneMode getRedstoneMode(Direction side, PipeType pipeType) {
        return (RedstoneMode)this.redstoneModes.getValue(side, pipeType);
    }

    public void setRedstoneMode(Direction side, PipeType pipeType, RedstoneMode redstoneMode) {
        this.redstoneModes.setValue(side, pipeType, redstoneMode);
    }

    public Distribution getDistribution(Direction side, PipeType pipeType) {
        return (Distribution)this.distributions.getValue(side, pipeType);
    }

    public void setDistribution(Direction side, PipeType pipeType, Distribution distribution) {
        this.distributions.setValue(side, pipeType, distribution);
    }

    public FilterMode getFilterMode(Direction side, PipeType pipeType) {
        return (FilterMode)this.filterModes.getValue(side, pipeType);
    }

    public void setFilterMode(Direction side, PipeType pipeType, FilterMode filterMode) {
        this.filterModes.setValue(side, pipeType, filterMode);
    }

    public <T> List<Filter<?, ?>> getFilters(Direction side, PipeType<T, ?> pipeType) {
        return (List)this.filters.getValue(side, pipeType);
    }

    public <T> void setFilters(Direction side, PipeType<T, ?> pipeType, List<Filter<?, ?>> filter) {
        this.filters.setValue(side, pipeType, filter);
    }

    @Override
    public void setExtracting(Direction side, boolean extracting) {
        super.setExtracting(side, extracting);
        if (!extracting) {
            ItemStack stack = (ItemStack)this.upgradeInventory.get(side.get3DDataValue());
            this.upgradeInventory.set(side.get3DDataValue(), (Object)ItemStack.EMPTY);
            Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (NonNullList)NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{stack}));
            this.setChanged();
        }
    }

    public Container getUpgradeInventory() {
        return this.inventory;
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.upgradeInventory.clear();
        ItemUtils.readInventory(valueInput, "Upgrades", this.upgradeInventory);
        this.invalidateAllCaches();
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ItemUtils.saveInventory(valueOutput, "Upgrades", this.upgradeInventory);
    }

    @Nullable
    public Upgrade getUpgrade(Direction direction) {
        ItemStack stack = (ItemStack)this.upgradeInventory.get(direction.get3DDataValue());
        Item item = stack.getItem();
        if (!(item instanceof UpgradeItem)) {
            return null;
        }
        UpgradeItem upgradeItem = (UpgradeItem)item;
        return upgradeItem.getTier();
    }

    public List<PipeTileEntity.Connection> getSortedConnections(Direction side, PipeType pipeType) {
        Distribution distribution = this.getDistribution(side, pipeType);
        switch (distribution.ordinal()) {
            case 1: {
                return this.getConnections().stream().sorted((o1, o2) -> Integer.compare(o2.getDistance(), o1.getDistance())).collect(Collectors.toList());
            }
            case 3: {
                ArrayList<PipeTileEntity.Connection> shuffle = new ArrayList<PipeTileEntity.Connection>(this.getConnections());
                Collections.shuffle(shuffle);
                return shuffle;
            }
        }
        return this.getConnections().stream().sorted(Comparator.comparingInt(PipeTileEntity.Connection::getDistance)).collect(Collectors.toList());
    }

    public static enum RedstoneMode implements ICyclable<RedstoneMode>
    {
        IGNORED("ignored"),
        OFF_WHEN_POWERED("off_when_powered"),
        ON_WHEN_POWERED("on_when_powered"),
        ALWAYS_OFF("always_off");

        private final String name;

        private RedstoneMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public RedstoneMode cycle() {
            return RedstoneMode.values()[Math.floorMod(this.ordinal() + 1, RedstoneMode.values().length)];
        }
    }

    public static enum Distribution implements ICyclable<Distribution>
    {
        NEAREST("nearest"),
        FURTHEST("furthest"),
        ROUND_ROBIN("round_robin"),
        RANDOM("random");

        private final String name;

        private Distribution(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public Distribution cycle() {
            return Distribution.values()[Math.floorMod(this.ordinal() + 1, Distribution.values().length)];
        }
    }

    public static enum FilterMode implements ICyclable<FilterMode>
    {
        WHITELIST("whitelist"),
        BLACKLIST("blacklist");

        private final String name;

        private FilterMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public FilterMode cycle() {
            return FilterMode.values()[Math.floorMod(this.ordinal() + 1, FilterMode.values().length)];
        }
    }

    public static interface ICyclable<T extends Enum<?>> {
        public T cycle();
    }
}

