/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.maxhenkel.pipez.ModelRegistry;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class PipeRenderer
implements BlockEntityRenderer<PipeTileEntity> {
    protected Minecraft minecraft;
    protected BlockEntityRendererProvider.Context renderer;
    protected AtomicReference<QuadCollection> cachedModel;

    public PipeRenderer(BlockEntityRendererProvider.Context renderer) {
        this.renderer = renderer;
        this.minecraft = Minecraft.getInstance();
        this.cachedModel = this.getModel().getModel();
    }

    public void render(PipeTileEntity pipe, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 vec) {
        QuadCollection model = this.cachedModel.get();
        if (model == null) {
            return;
        }
        List quads = model.getQuads(null);
        VertexConsumer b = buffer.getBuffer(RenderType.solid());
        for (Direction side : Direction.values()) {
            if (!pipe.isExtracting(side)) continue;
            this.renderExtractor(side, matrixStack, b, quads, combinedLight, combinedOverlay);
        }
    }

    private void renderExtractor(Direction direction, PoseStack matrixStack, VertexConsumer b, List<BakedQuad> quads, int combinedLight, int combinedOverlay) {
        matrixStack.pushPose();
        matrixStack.translate((double)direction.getStepX() * 0.001, (double)direction.getStepY() * 0.001, (double)direction.getStepZ() * 0.001);
        matrixStack.translate(0.5, 0.5, 0.5);
        matrixStack.mulPose((Quaternionfc)this.getRotation(direction));
        matrixStack.translate(-0.5, -0.5, -0.5);
        for (BakedQuad quad : quads) {
            b.putBulkData(matrixStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay);
        }
        matrixStack.popPose();
    }

    private Quaternionf getRotation(Direction direction) {
        Quaternionf q = new Quaternionf();
        switch (direction) {
            case NORTH: {
                return q;
            }
            case SOUTH: {
                q.mul((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                return q;
            }
            case WEST: {
                q.mul((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                return q;
            }
            case EAST: {
                q.mul((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
                return q;
            }
            case UP: {
                q.mul((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                return q;
            }
        }
        q.mul((Quaternionfc)Axis.XP.rotationDegrees(270.0f));
        return q;
    }

    abstract ModelRegistry.Model getModel();
}

