/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.gui;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CycleIconButton
extends AbstractButton {
    private List<Icon> icons;
    private Supplier<Integer> index;
    private Consumer<CycleIconButton> onPress;

    public CycleIconButton(int x, int y, List<Icon> icons, Supplier<Integer> index, Consumer<CycleIconButton> onPress) {
        super(x, y, 20, 20, (Component)Component.empty());
        this.icons = icons;
        this.index = index;
        this.onPress = onPress;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        Icon icon = this.icons.get(this.index.get());
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, icon.texture, this.getX() + 2, this.getY() + 2, (float)icon.offsetX, (float)icon.offsetY, 16, 16, 256, 256);
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
        this.defaultButtonNarrationText(output);
    }

    public void onPress() {
        this.onPress.accept(this);
    }

    public static class Icon {
        private ResourceLocation texture;
        private int offsetX;
        private int offsetY;

        public Icon(ResourceLocation texture, int offsetX, int offsetY) {
            this.texture = texture;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }
    }
}

