/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.integration.waila;

import de.maxhenkel.pipez.blocks.PipeBlock;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.corelib.codec.CodecUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;

public class DataProviderPipes
implements IServerDataProvider<BlockAccessor> {
    static final DataProviderPipes INSTANCE = new DataProviderPipes();
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"pipez", (String)"pipe_data");

    public void appendServerData(CompoundTag compound, BlockAccessor blockAccessor) {
        Block block = blockAccessor.getBlockState().getBlock();
        if (block instanceof PipeBlock) {
            PipeBlock pipe = (PipeBlock)block;
            BlockEntity te = blockAccessor.getBlockEntity();
            Direction selectedSide = pipe.getSelection(te.getBlockState(), (BlockGetter)blockAccessor.getLevel(), te.getBlockPos(), blockAccessor.getPlayer()).getKey();
            if (selectedSide == null) {
                return;
            }
            if (!(te instanceof UpgradeTileEntity)) {
                return;
            }
            PipeLogicTileEntity pipeTile = (PipeLogicTileEntity)te;
            if (!pipeTile.isExtracting(selectedSide)) {
                return;
            }
            ItemStack upgrade = pipeTile.getUpgradeItem(selectedSide);
            if (upgrade.isEmpty()) {
                CodecUtils.toJsonString(ComponentSerialization.CODEC, Component.translatable((String)"tooltip.pipez.no_upgrade")).ifPresent(s -> compound.putString("Upgrade", s));
            } else {
                CodecUtils.toJsonString(ComponentSerialization.CODEC, upgrade.getHoverName()).ifPresent(s -> compound.putString("Upgrade", s));
            }
            ArrayList<Component> tooltips = new ArrayList<Component>();
            for (PipeType<?, ?> pipeType : pipeTile.getPipeTypes()) {
                if (!pipeTile.isEnabled(selectedSide, pipeType)) continue;
                tooltips.add(pipeType.getTransferText(pipeTile.getUpgrade(selectedSide)));
            }
            this.putTooltips(blockAccessor, compound, tooltips);
        }
    }

    public void putTooltips(BlockAccessor blockAccessor, CompoundTag compound, List<Component> tooltips) {
        ListTag list = new ListTag();
        for (Component tooltip : tooltips) {
            CodecUtils.toJsonString(ComponentSerialization.CODEC, tooltip).ifPresent(s -> list.add((Object)StringTag.valueOf((String)s)));
        }
        compound.put("Tooltips", (Tag)list);
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

