/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.net;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.corelib.net.Message;
import de.maxhenkel.pipez.gui.ExtractContainer;
import de.maxhenkel.pipez.gui.FilterContainer;
import de.maxhenkel.pipez.gui.containerfactory.FilterContainerProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class EditFilterMessage
implements Message<EditFilterMessage> {
    public static final CustomPacketPayload.Type<EditFilterMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"pipez", (String)"edit_filter_message"));
    private Filter filter;
    private CompoundTag filterTag;
    private int index;

    public EditFilterMessage() {
    }

    public EditFilterMessage(Filter filter, int index) {
        this.filter = filter;
        this.index = index;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        AbstractContainerMenu abstractContainerMenu = sender.containerMenu;
        if (!(abstractContainerMenu instanceof ExtractContainer)) {
            return;
        }
        ExtractContainer extractContainer = (ExtractContainer)abstractContainerMenu;
        this.filter = extractContainer.getPipe().getPipeTypes()[this.index].createFilter();
        if (this.filter == null) {
            return;
        }
        this.filter = this.filter.fromNbt(this.filterTag);
        FilterContainerProvider.openGui((Player)sender, extractContainer.getPipe(), extractContainer.getSide(), this.filter, this.index, (id, playerInventory, playerEntity) -> new FilterContainer(id, (Container)playerInventory, extractContainer.getPipe(), extractContainer.getSide(), this.index, this.filter));
    }

    @Override
    public EditFilterMessage fromBytes(RegistryFriendlyByteBuf packetBuffer) {
        this.filterTag = packetBuffer.readNbt();
        this.index = packetBuffer.readInt();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf packetBuffer) {
        packetBuffer.writeNbt((Tag)this.filter.toNbt());
        packetBuffer.writeInt(this.index);
    }

    @Override
    public CustomPacketPayload.Type<EditFilterMessage> type() {
        return TYPE;
    }
}

