/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.utils;

import de.maxhenkel.pipez.capabilities.ModCapabilities;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.corelib.tag.Tag;
import de.maxhenkel.pipez.utils.ChemicalTag;
import java.util.Optional;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.ItemCapability;

public class GasUtils {
    public static final Tag<Chemical> EMPTY_CHEMICAL_TAG = new SingleElementTag<Chemical>(ChemicalStack.EMPTY.getChemical().getRegistryName(), ChemicalStack.EMPTY.getChemical());

    @Nullable
    public static Tag<? extends Chemical> getGas(String name, boolean nullIfNotExists) {
        if (name.startsWith("#")) {
            ResourceLocation resourceLocation = ResourceLocation.tryParse((String)name.substring(1));
            if (resourceLocation == null) {
                return nullIfNotExists ? null : EMPTY_CHEMICAL_TAG;
            }
            return GasUtils.getGasTag(resourceLocation, nullIfNotExists);
        }
        ResourceLocation id = ResourceLocation.tryParse((String)name);
        if (id == null) {
            return nullIfNotExists ? null : EMPTY_CHEMICAL_TAG;
        }
        if (!MekanismAPI.CHEMICAL_REGISTRY.containsKey(id)) {
            return nullIfNotExists ? null : EMPTY_CHEMICAL_TAG;
        }
        return new SingleElementTag<Chemical>(id, MekanismAPI.CHEMICAL_REGISTRY.get(id).map(Holder.Reference::value).orElse(MekanismAPI.EMPTY_CHEMICAL));
    }

    @Nullable
    public static Tag<Chemical> getGasTag(ResourceLocation id, boolean nullIfNotExists) {
        DefaultedRegistry registry = MekanismAPI.CHEMICAL_REGISTRY;
        TagKey tagKey = TagKey.create((ResourceKey)MekanismAPI.CHEMICAL_REGISTRY_NAME, (ResourceLocation)id);
        Optional tag = registry.get(tagKey);
        if (tag.isEmpty()) {
            return nullIfNotExists ? null : EMPTY_CHEMICAL_TAG;
        }
        return new ChemicalTag((HolderSet.Named<Chemical>)((HolderSet.Named)tag.get()), id);
    }

    @Nullable
    public static ChemicalStack getGasContained(ItemStack stack) {
        ChemicalStack gas = GasUtils.getGasContained(stack, ModCapabilities.CHEMICAL_HANDLER_ITEM_CAPABILITY);
        if (gas == null || gas.isEmpty()) {
            return null;
        }
        return gas;
    }

    @Nullable
    public static ChemicalStack getGasContained(ItemStack stack, ItemCapability<? extends IChemicalHandler, Void> capability) {
        IChemicalHandler handler = (IChemicalHandler)stack.getCapability(capability, null);
        if (handler == null) {
            return null;
        }
        if (handler.getChemicalTanks() <= 0) {
            return null;
        }
        return handler.getChemicalInTank(0).copy();
    }

    public static boolean hasChemicalCapability(Level world, BlockPos pos, Direction facing) {
        return world.getCapability(ModCapabilities.CHEMICAL_HANDLER_CAPABILITY, pos, (Object)facing) != null;
    }
}

