/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.utils;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;

public class NbtUtils {
    public static Optional<CompoundTag> componentPatchToNbtOptional(DataComponentPatch patch) {
        if (patch.isEmpty()) {
            return Optional.empty();
        }
        return NbtUtils.codecToNbtOptional(DataComponentPatch.CODEC, patch);
    }

    public static <T> Optional<T> nbtToCodecOptional(Codec<T> codec, CompoundTag tag) {
        return codec.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).result().map(Pair::getFirst);
    }

    public static <T> Optional<CompoundTag> codecToNbtOptional(Codec<T> codec, T value) {
        return codec.encodeStart((DynamicOps)NbtOps.INSTANCE, value).result().filter(tag -> tag instanceof CompoundTag).map(CompoundTag.class::cast);
    }

    public static <T> CompoundTag codecToNbtDefault(Codec<T> codec, T value) {
        return NbtUtils.codecToNbtOptional(codec, value).orElse(new CompoundTag());
    }
}

