/*
 * Decompiled with CFR 0.152.
 */
package ru.fewizz.crawl.client.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.fewizz.crawl.Crawl;
import ru.fewizz.crawl.PlayerExtended;
import ru.fewizz.crawl.client.CrawlClient;
import ru.fewizz.crawl.client.mixininterface.CrawlingState;

@Mixin(value={PlayerRenderer.class})
abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerRenderState, PlayerModel> {
    PlayerRendererMixin() {
        super(null, null, 0.0f);
    }

    @Inject(method={"extractRenderState"}, at={@At(value="TAIL")})
    void onUpdateRenderState(AbstractClientPlayer e, PlayerRenderState state, float tickDelta, CallbackInfo ci) {
        boolean crawling = e.getPose() == Crawl.Shared.CRAWLING || e.getSwimAmount(tickDelta) > 0.0f && ((PlayerExtended)e).crawl_wasPreviouslyCrawling();
        ((CrawlingState)state).setCrawling(CrawlClient.replaceAnimation ? crawling : false);
        state.isVisuallySwimming = state.isVisuallySwimming | (!CrawlClient.replaceAnimation && crawling);
        state.isCrouching = state.isCrouching & !crawling;
    }

    @ModifyExpressionValue(method={"setupRotations"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;swimAmount:F")})
    float rotateWhenCrawlingSameWayAsWhenSwimming(float swimAmount, @Local PlayerRenderState state) {
        if (CrawlClient.replaceAnimation && ((CrawlingState)state).isCrawling()) {
            swimAmount += 1.0E-4f;
        }
        return swimAmount;
    }

    @ModifyExpressionValue(method={"setupRotations"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;isVisuallySwimming:Z")})
    boolean applyXRotationWhenCrawling(boolean isVisuallySwimming, @Local PlayerRenderState state) {
        return CrawlClient.replaceAnimation && ((CrawlingState)state).isCrawling() || isVisuallySwimming;
    }

    @ModifyExpressionValue(method={"setupRotations"}, at={@At(value="CONSTANT", args={"floatValue=-1.0F"})})
    float smootherYOffsetSwimmingPosTransition(float original, @Local PlayerRenderState state) {
        return Mth.lerp((float)state.swimAmount, (float)0.0f, (float)original);
    }

    @ModifyExpressionValue(method={"setupRotations"}, at={@At(value="CONSTANT", args={"floatValue=0.3F"})})
    float smootherZOffsetSwimmingPosTransition(float original, @Local PlayerRenderState state) {
        return Mth.lerp((float)state.swimAmount, (float)0.0f, (float)(original - 0.1f));
    }
}

