/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.gametest;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesItemStackTag;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integratedcrafting.gametest.GameTestHelpersIntegratedCrafting;
import org.cyclops.integratedcrafting.part.aspect.CraftingAspectWriteBuilders;
import org.cyclops.integratedcrafting.part.aspect.CraftingAspects;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integratedtunnels.part.PartTypes;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspects;

public class GameTestsItemsCraft {
    public static final String TEMPLATE_EMPTY = "integratedcrafting:empty10";
    public static final int TIMEOUT = 2000;
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="integratedcrafting:empty10", timeoutTicks=2000)
    public void testItemsCraftChestOne(GameTestHelper helper) {
        GameTestHelpersIntegratedCrafting.NetworkPositions positions = GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, POS);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.OAK_PLANKS, 64));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)0, (Object)RecipeType.CRAFTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chest")));
        GameTestHelpersIntegratedCrafting.enableRecipeInWriter(helper, positions.writer(), new ItemStack((ItemLike)Items.CHEST));
        helper.succeedWhen(() -> {
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface is not valid"));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.NORTH)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Importer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)org.cyclops.integratedcrafting.part.PartTypes.CRAFTING_WRITER.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.NORTH)), Direction.NORTH).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), CraftingAspects.Write.ITEMSTACK_CRAFT, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(CraftingAspects.Write.ITEMSTACK_CRAFT).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getItem(), (Object)Items.OAK_PLANKS, (Component)Component.literal((String)"Slot 0 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getCount(), (Object)56, (Component)Component.literal((String)"Slot 0 amount is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(1).getItem(), (Object)Items.CHEST, (Component)Component.literal((String)"Slot 1 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(1).getCount(), (Object)1, (Component)Component.literal((String)"Slot 1 amount is incorrect"));
        });
    }

    @GameTest(template="integratedcrafting:empty10", timeoutTicks=2000)
    public void testItemsCraftChestAll(GameTestHelper helper) {
        GameTestHelpersIntegratedCrafting.NetworkPositions positions = GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, POS);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.OAK_PLANKS, 64));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)0, (Object)RecipeType.CRAFTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chest")));
        GameTestHelpersIntegratedCrafting.enableRecipeInWriter(helper, positions.writer(), new ItemStack((ItemLike)Items.CHEST));
        GameTestHelpersIntegratedCrafting.setWriterAspectProperty(positions.writer(), CraftingAspects.Write.ITEMSTACK_CRAFT, CraftingAspectWriteBuilders.PROP_IGNORE_STORAGE, ValueTypeBoolean.ValueBoolean.of((boolean)true));
        helper.succeedWhen(() -> {
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface is not valid"));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.NORTH)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Importer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)org.cyclops.integratedcrafting.part.PartTypes.CRAFTING_WRITER.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.NORTH)), Direction.NORTH).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), CraftingAspects.Write.ITEMSTACK_CRAFT, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(CraftingAspects.Write.ITEMSTACK_CRAFT).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getItem(), (Object)Items.CHEST, (Component)Component.literal((String)"Slot 0 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getCount(), (Object)1, (Component)Component.literal((String)"Slot 0 amount is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(1).getItem(), (Object)Items.CHEST, (Component)Component.literal((String)"Slot 1 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(1).getCount(), (Object)7, (Component)Component.literal((String)"Slot 1 amount is incorrect"));
        });
    }

    @GameTest(template="integratedcrafting:empty10", timeoutTicks=2000)
    public void testItemsCraftIronIngot(GameTestHelper helper) {
        GameTestHelpersIntegratedCrafting.NetworkPositions positions = GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, POS, Blocks.FURNACE);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.RAW_IRON, 1));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)0, (Object)RecipeType.SMELTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iron_ingot_from_smelting_raw_iron")));
        GameTestHelpersIntegratedCrafting.enableRecipeInWriter(helper, positions.writer(), new ItemStack((ItemLike)Items.IRON_INGOT));
        helper.succeedWhen(() -> {
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface is not valid"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getItem(), (Object)Items.IRON_INGOT, (Component)Component.literal((String)"Slot 0 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getCount(), (Object)1, (Component)Component.literal((String)"Slot 0 amount is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(1).getCount(), (Object)0, (Component)Component.literal((String)"Slot 1 amount is incorrect"));
        });
    }

    @GameTest(template="integratedcrafting:empty10", timeoutTicks=2000)
    public void testItemsCraftIronIngotRecipeWithEmptySpaces(GameTestHelper helper) {
        GameTestHelpersIntegratedCrafting.NetworkPositions positions = GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, POS, Blocks.FURNACE);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.RAW_IRON, 1));
        IdentityHashMap recipeIn = Maps.newIdentityHashMap();
        ArrayList alternatives = Lists.newArrayList();
        IdentityHashMap recipeOut = Maps.newIdentityHashMap();
        alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)5)})));
        alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)5)})));
        alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)5)})));
        alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)5)})));
        alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.RAW_IRON), (Object)5)})));
        recipeIn.put(IngredientComponents.ITEMSTACK, alternatives);
        recipeOut.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.IRON_INGOT)}));
        ItemStack variableRecipe = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_RECIPE, (IValue)ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)new RecipeDefinition((Map)recipeIn, (IMixedIngredients)new MixedIngredients((Map)recipeOut))));
        positions.interfaceStates().get(0).getInventoryVariables().setItem(0, variableRecipe);
        GameTestHelpersIntegratedCrafting.enableRecipeInWriter(helper, positions.writer(), new ItemStack((ItemLike)Items.IRON_INGOT));
        helper.succeedWhen(() -> {
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface is not valid"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getItem(), (Object)Items.IRON_INGOT, (Component)Component.literal((String)"Slot 0 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getCount(), (Object)1, (Component)Component.literal((String)"Slot 0 amount is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(1).getCount(), (Object)0, (Component)Component.literal((String)"Slot 1 amount is incorrect"));
        });
    }

    @GameTest(template="integratedcrafting:empty10", timeoutTicks=2000)
    public void testItemsCraftChestFromLogs(GameTestHelper helper) {
        GameTestHelpersIntegratedCrafting.NetworkPositions positions = GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, POS);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.OAK_LOG, 2));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)0, (Object)RecipeType.CRAFTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chest")));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)1, (Object)RecipeType.CRAFTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"oak_planks")));
        GameTestHelpersIntegratedCrafting.enableRecipeInWriter(helper, positions.writer(), new ItemStack((ItemLike)Items.CHEST));
        helper.succeedWhen(() -> {
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe 0 in crafting interface is not valid"));
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(1), (Component)Component.literal((String)"Recipe 1 in crafting interface is not valid"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getItem(), (Object)Items.CHEST, (Component)Component.literal((String)"Slot 1 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getCount(), (Object)1, (Component)Component.literal((String)"Slot 1 amount is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(1).getCount(), (Object)0, (Component)Component.literal((String)"Slot 1 amount is incorrect"));
        });
    }

    @GameTest(template="integratedcrafting:empty10", timeoutTicks=2000)
    public void testItemsCraftIronIngotsParallel(GameTestHelper helper) {
        GameTestHelpersIntegratedCrafting.NetworkPositions positions = GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, POS, Blocks.FURNACE, Blocks.FURNACE, Blocks.FURNACE, Blocks.FURNACE, Blocks.FURNACE);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.RAW_IRON, 5));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)0, (Object)RecipeType.SMELTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iron_ingot_from_smelting_raw_iron")));
        positions.interfaceRecipeAdders().get(1).accept(Triple.of((Object)0, (Object)RecipeType.SMELTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iron_ingot_from_smelting_raw_iron")));
        positions.interfaceRecipeAdders().get(2).accept(Triple.of((Object)0, (Object)RecipeType.SMELTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iron_ingot_from_smelting_raw_iron")));
        positions.interfaceRecipeAdders().get(3).accept(Triple.of((Object)0, (Object)RecipeType.SMELTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iron_ingot_from_smelting_raw_iron")));
        positions.interfaceRecipeAdders().get(4).accept(Triple.of((Object)0, (Object)RecipeType.SMELTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iron_ingot_from_smelting_raw_iron")));
        GameTestHelpersIntegratedCrafting.enableRecipeInWriter(helper, positions.writer(), new ItemStack((ItemLike)Items.IRON_INGOT, 5));
        helper.succeedWhen(() -> {
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface 0 is not valid"));
            helper.assertTrue(positions.interfaceStates().get(1).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface 1 is not valid"));
            helper.assertTrue(positions.interfaceStates().get(2).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface 2 is not valid"));
            helper.assertTrue(positions.interfaceStates().get(3).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface 3 is not valid"));
            helper.assertTrue(positions.interfaceStates().get(4).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface 4 is not valid"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getItem(), (Object)Items.IRON_INGOT, (Component)Component.literal((String)"Slot 0 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getCount(), (Object)5, (Component)Component.literal((String)"Slot 0 amount is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(1).getCount(), (Object)0, (Component)Component.literal((String)"Slot 1 amount is incorrect"));
            helper.assertBlockProperty(POS.west(), (Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true));
            helper.assertBlockProperty(POS.south().west(), (Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true));
            helper.assertBlockProperty(POS.south().south().west(), (Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true));
            helper.assertBlockProperty(POS.south().south().south().west(), (Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true));
            helper.assertBlockProperty(POS.south().south().south().south().west(), (Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true));
        });
    }

    @GameTest(template="integratedcrafting:empty10", timeoutTicks=2000)
    public void testItemsCraftIronIngotsParallelMultipleNonBlocking(GameTestHelper helper) {
        GameTestHelpersIntegratedCrafting.NetworkPositions positions = GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, POS, Blocks.FURNACE, Blocks.FURNACE, Blocks.FURNACE, Blocks.FURNACE, Blocks.FURNACE);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.RAW_IRON, 10));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)0, (Object)RecipeType.SMELTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iron_ingot_from_smelting_raw_iron")));
        positions.interfaceRecipeAdders().get(1).accept(Triple.of((Object)0, (Object)RecipeType.SMELTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iron_ingot_from_smelting_raw_iron")));
        positions.interfaceRecipeAdders().get(2).accept(Triple.of((Object)0, (Object)RecipeType.SMELTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iron_ingot_from_smelting_raw_iron")));
        positions.interfaceRecipeAdders().get(3).accept(Triple.of((Object)0, (Object)RecipeType.SMELTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iron_ingot_from_smelting_raw_iron")));
        positions.interfaceRecipeAdders().get(4).accept(Triple.of((Object)0, (Object)RecipeType.SMELTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iron_ingot_from_smelting_raw_iron")));
        GameTestHelpersIntegratedCrafting.enableRecipeInWriter(helper, positions.writer(), new ItemStack((ItemLike)Items.IRON_INGOT, 10));
        GameTestHelpersIntegratedCrafting.setCraftingInterfaceBlockingMode(positions.interfaces().get(0), false);
        GameTestHelpersIntegratedCrafting.setCraftingInterfaceBlockingMode(positions.interfaces().get(1), false);
        GameTestHelpersIntegratedCrafting.setCraftingInterfaceBlockingMode(positions.interfaces().get(2), false);
        GameTestHelpersIntegratedCrafting.setCraftingInterfaceBlockingMode(positions.interfaces().get(3), false);
        GameTestHelpersIntegratedCrafting.setCraftingInterfaceBlockingMode(positions.interfaces().get(4), false);
        helper.succeedWhen(() -> {
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface 0 is not valid"));
            helper.assertTrue(positions.interfaceStates().get(1).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface 1 is not valid"));
            helper.assertTrue(positions.interfaceStates().get(2).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface 2 is not valid"));
            helper.assertTrue(positions.interfaceStates().get(3).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface 3 is not valid"));
            helper.assertTrue(positions.interfaceStates().get(4).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface 4 is not valid"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getItem(), (Object)Items.IRON_INGOT, (Component)Component.literal((String)"Slot 0 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getCount(), (Object)10, (Component)Component.literal((String)"Slot 0 amount is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(1).getCount(), (Object)0, (Component)Component.literal((String)"Slot 1 amount is incorrect"));
            helper.assertBlockProperty(POS.west(), (Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true));
            helper.assertBlockProperty(POS.south().west(), (Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true));
            helper.assertBlockProperty(POS.south().south().west(), (Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true));
            helper.assertBlockProperty(POS.south().south().south().west(), (Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true));
            helper.assertBlockProperty(POS.south().south().south().south().west(), (Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true));
        });
    }

    @GameTest(template="integratedcrafting:empty10", timeoutTicks=2000)
    public void testItemsCraftCrafterComplex(GameTestHelper helper) {
        GameTestHelpersIntegratedCrafting.NetworkPositions positions = GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, POS, Blocks.CRAFTING_TABLE, Blocks.FURNACE, Blocks.FURNACE, Blocks.FURNACE, Blocks.FURNACE, Blocks.FURNACE);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.OAK_LOG, 1));
        chestIn.setItem(1, new ItemStack((ItemLike)Items.RAW_IRON, 5));
        chestIn.setItem(2, new ItemStack((ItemLike)Items.REDSTONE_BLOCK, 2));
        chestIn.setItem(3, new ItemStack((ItemLike)Items.COBBLESTONE, 7));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)0, (Object)RecipeType.CRAFTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"oak_planks")));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)1, (Object)RecipeType.CRAFTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"crafting_table")));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)2, (Object)RecipeType.CRAFTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"redstone")));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)3, (Object)RecipeType.CRAFTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"crafter")));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)4, (Object)RecipeType.CRAFTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"dropper")));
        positions.interfaceRecipeAdders().get(1).accept(Triple.of((Object)0, (Object)RecipeType.SMELTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iron_ingot_from_smelting_raw_iron")));
        positions.interfaceRecipeAdders().get(2).accept(Triple.of((Object)1, (Object)RecipeType.SMELTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iron_ingot_from_smelting_raw_iron")));
        positions.interfaceRecipeAdders().get(3).accept(Triple.of((Object)2, (Object)RecipeType.SMELTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iron_ingot_from_smelting_raw_iron")));
        positions.interfaceRecipeAdders().get(4).accept(Triple.of((Object)3, (Object)RecipeType.SMELTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iron_ingot_from_smelting_raw_iron")));
        positions.interfaceRecipeAdders().get(5).accept(Triple.of((Object)4, (Object)RecipeType.SMELTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iron_ingot_from_smelting_raw_iron")));
        GameTestHelpersIntegratedCrafting.enableRecipeInWriter(helper, positions.writer(), new ItemStack((ItemLike)Items.CRAFTER));
        helper.succeedWhen(() -> {
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe 0 in crafting interface 0 is not valid"));
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(1), (Component)Component.literal((String)"Recipe 1 in crafting interface 0 is not valid"));
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(2), (Component)Component.literal((String)"Recipe 2 in crafting interface 0 is not valid"));
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(3), (Component)Component.literal((String)"Recipe 3 in crafting interface 0 is not valid"));
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(4), (Component)Component.literal((String)"Recipe 4 in crafting interface 0 is not valid"));
            helper.assertTrue(positions.interfaceStates().get(1).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe 0 in crafting interface 1 is not valid"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getItem(), (Object)Items.CRAFTER, (Component)Component.literal((String)"Slot 0 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getCount(), (Object)1, (Component)Component.literal((String)"Slot 0 amount is incorrect"));
        });
    }

    @GameTest(template="integratedcrafting:empty10", timeoutTicks=2000)
    public void testItemsCraftPlanksAndExtractFromStorage(GameTestHelper helper) {
        GameTestHelpersIntegratedCrafting.NetworkPositions positions = GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, POS);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.OAK_LOG, 64));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)0, (Object)RecipeType.CRAFTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"oak_planks")));
        GameTestHelpersIntegratedCrafting.enableRecipeInWriter(helper, positions.writer(), new ItemStack((ItemLike)Items.OAK_PLANKS));
        GameTestHelpersIntegratedCrafting.setWriterAspectProperty(positions.writer(), CraftingAspects.Write.ITEMSTACK_CRAFT, CraftingAspectWriteBuilders.PROP_IGNORE_STORAGE, ValueTypeBoolean.ValueBoolean.of((boolean)true));
        helper.setBlock(positions.chest().south(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(positions.chest().south().south(), Blocks.CHEST);
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(positions.chest().south()), (Direction)Direction.SOUTH, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(positions.chest().south()), (Direction)Direction.NORTH, (IPartType)PartTypes.IMPORTER_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_ITEM.getItem()));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(positions.chest().south()), (Direction)Direction.NORTH), (IAspectWrite)TunnelAspects.Write.Item.ITEMSTACK_IMPORT, (ItemStack)GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_ITEMSTACK, (IValue)ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)Items.OAK_PLANKS))));
        helper.succeedWhen(() -> {
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface is not valid"));
            helper.assertTrue(chestIn.getItem(0).isEmpty(), (Component)Component.literal((String)"Slot 0 item is incorrect"));
        });
    }

    @GameTest(template="integratedcrafting:empty10", timeoutTicks=2000)
    public void testItemsCraftDeadBushTag(GameTestHelper helper) {
        GameTestHelpersIntegratedCrafting.NetworkPositions positions = GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, POS);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.SHEARS, 1));
        chestIn.setItem(1, new ItemStack((ItemLike)Items.SPRUCE_SAPLING, 10));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)0, (Object)RecipeType.CRAFTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"integratedcrafting", (String)"special/minecraft_dead_bush")));
        GameTestHelpersIntegratedCrafting.enableRecipeInWriter(helper, positions.writer(), new ItemStack((ItemLike)Items.DEAD_BUSH));
        GameTestHelpersIntegratedCrafting.setWriterAspectProperty(positions.writer(), CraftingAspects.Write.ITEMSTACK_CRAFT, CraftingAspectWriteBuilders.PROP_IGNORE_STORAGE, ValueTypeBoolean.ValueBoolean.of((boolean)true));
        helper.succeedWhen(() -> {
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface is not valid"));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.NORTH)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Importer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)org.cyclops.integratedcrafting.part.PartTypes.CRAFTING_WRITER.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.NORTH)), Direction.NORTH).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), CraftingAspects.Write.ITEMSTACK_CRAFT, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(CraftingAspects.Write.ITEMSTACK_CRAFT).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getItem(), (Object)Items.DEAD_BUSH, (Component)Component.literal((String)"Slot 0 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getCount(), (Object)10, (Component)Component.literal((String)"Slot 0 amount is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(1).getItem(), (Object)Items.SHEARS, (Component)Component.literal((String)"Slot 1 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(1).getCount(), (Object)1, (Component)Component.literal((String)"Slot 1 amount is incorrect"));
        });
    }

    @GameTest(template="integratedcrafting:empty10", timeoutTicks=2000)
    public void testItemsCraftDeadBushTagReusable(GameTestHelper helper) {
        GameTestHelpersIntegratedCrafting.NetworkPositions positions = GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, POS);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.SHEARS, 1));
        chestIn.setItem(1, new ItemStack((ItemLike)Items.SPRUCE_SAPLING, 10));
        GameTestsItemsCraft.createDeadBushTagReusableRecipe(helper, positions);
        GameTestHelpersIntegratedCrafting.enableRecipeInWriter(helper, positions.writer(), new ItemStack((ItemLike)Items.DEAD_BUSH, 10));
        helper.succeedWhen(() -> {
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface is not valid"));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.NORTH)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Importer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)org.cyclops.integratedcrafting.part.PartTypes.CRAFTING_WRITER.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.NORTH)), Direction.NORTH).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), CraftingAspects.Write.ITEMSTACK_CRAFT, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(CraftingAspects.Write.ITEMSTACK_CRAFT).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getItem(), (Object)Items.DEAD_BUSH, (Component)Component.literal((String)"Slot 0 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getCount(), (Object)10, (Component)Component.literal((String)"Slot 0 amount is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(1).getItem(), (Object)Items.SHEARS, (Component)Component.literal((String)"Slot 1 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(1).getCount(), (Object)1, (Component)Component.literal((String)"Slot 1 amount is incorrect"));
        });
    }

    protected static void createDeadBushTagReusableRecipe(GameTestHelper helper, GameTestHelpersIntegratedCrafting.NetworkPositions positions) {
        IdentityHashMap recipeIn = Maps.newIdentityHashMap();
        ArrayList alternatives = Lists.newArrayList();
        IdentityHashMap recipeOut = Maps.newIdentityHashMap();
        alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.SPRUCE_SAPLING), (Object)5)})));
        alternatives.add(new PrototypedIngredientAlternativesItemStackTag((List)Lists.newArrayList((Object[])new String[]{"c:tools/shear"}), Integer.valueOf(1), 1L));
        recipeIn.put(IngredientComponents.ITEMSTACK, alternatives);
        IdentityHashMap inputsReusable = Maps.newIdentityHashMap();
        inputsReusable.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new Boolean[]{false, true}));
        recipeOut.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.DEAD_BUSH)}));
        ItemStack variableRecipe = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_RECIPE, (IValue)ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)new RecipeDefinition((Map)recipeIn, (Map)inputsReusable, (IMixedIngredients)new MixedIngredients((Map)recipeOut))));
        positions.interfaceStates().get(0).getInventoryVariables().setItem(0, variableRecipe);
    }

    @GameTest(template="integratedcrafting:empty10", timeoutTicks=2000)
    public void testItemsCraftDeadBushTagReusableAsDependency(GameTestHelper helper) {
        GameTestHelpersIntegratedCrafting.NetworkPositions positions = GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, POS, Blocks.CRAFTING_TABLE, Blocks.CRAFTING_TABLE);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.SHEARS, 1));
        chestIn.setItem(1, new ItemStack((ItemLike)Items.SHEARS, 1));
        chestIn.setItem(2, new ItemStack((ItemLike)Items.SPRUCE_SAPLING, 64));
        chestIn.setItem(3, new ItemStack((ItemLike)Items.SPRUCE_SAPLING, 64));
        chestIn.setItem(4, new ItemStack((ItemLike)Items.SPRUCE_SAPLING, 64));
        chestIn.setItem(5, new ItemStack((ItemLike)Items.SPRUCE_SAPLING, 64));
        chestIn.setItem(6, new ItemStack((ItemLike)Items.SPRUCE_SAPLING, 64));
        GameTestsItemsCraft.createDeadBushTagReusableRecipe(helper, positions);
        positions.interfaceRecipeAdders().get(1).accept(Triple.of((Object)0, (Object)RecipeType.CRAFTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"integratedcrafting", (String)"special/dead_bush_to_gold")));
        GameTestHelpersIntegratedCrafting.setCraftingInterfaceUpdateInterval(positions.interfaces().get(0), 1);
        GameTestHelpersIntegratedCrafting.setCraftingInterfaceUpdateInterval(positions.interfaces().get(1), 1);
        GameTestHelpersIntegratedCrafting.enableRecipeInWriter(helper, positions.writer(), new ItemStack((ItemLike)Items.GOLD_INGOT, 320));
        helper.succeedWhen(() -> {
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface is not valid"));
            helper.assertTrue(positions.interfaceStates().get(1).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface is not valid"));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.NORTH)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Importer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)org.cyclops.integratedcrafting.part.PartTypes.CRAFTING_WRITER.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.NORTH)), Direction.NORTH).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), CraftingAspects.Write.ITEMSTACK_CRAFT, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(CraftingAspects.Write.ITEMSTACK_CRAFT).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getItem(), (Object)Items.GOLD_INGOT, (Component)Component.literal((String)"Slot 0 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getCount(), (Object)64, (Component)Component.literal((String)"Slot 0 amount is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(1).getItem(), (Object)Items.GOLD_INGOT, (Component)Component.literal((String)"Slot 1 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(1).getCount(), (Object)64, (Component)Component.literal((String)"Slot 1 amount is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(2).getItem(), (Object)Items.GOLD_INGOT, (Component)Component.literal((String)"Slot 2 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(2).getCount(), (Object)64, (Component)Component.literal((String)"Slot 2 amount is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(3).getItem(), (Object)Items.GOLD_INGOT, (Component)Component.literal((String)"Slot 3 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(3).getCount(), (Object)64, (Component)Component.literal((String)"Slot 3 amount is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(4).getItem(), (Object)Items.GOLD_INGOT, (Component)Component.literal((String)"Slot 4 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(4).getCount(), (Object)64, (Component)Component.literal((String)"Slot 4 amount is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(6).getItem(), (Object)Items.SHEARS, (Component)Component.literal((String)"Slot 6 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(6).getCount(), (Object)1, (Component)Component.literal((String)"Slot 6 amount is incorrect"));
        });
    }

    @GameTest(template="integratedcrafting:empty10", timeoutTicks=2000)
    public void testItemsCraftCraftingTablesWithExistingPlank(GameTestHelper helper) {
        GameTestHelpersIntegratedCrafting.NetworkPositions positions = GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, POS, Blocks.CRAFTING_TABLE);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.OAK_LOG, 2));
        chestIn.setItem(1, new ItemStack((ItemLike)Items.OAK_PLANKS, 1));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)0, (Object)RecipeType.CRAFTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"oak_planks")));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)1, (Object)RecipeType.CRAFTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"crafting_table")));
        GameTestHelpersIntegratedCrafting.enableRecipeInWriter(helper, positions.writer(), new ItemStack((ItemLike)Items.CRAFTING_TABLE, 2));
        helper.succeedWhen(() -> {
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe 0 in crafting interface 0 is not valid"));
            helper.assertTrue(positions.interfaceStates().get(0).isRecipeSlotValid(1), (Component)Component.literal((String)"Recipe 1 in crafting interface 0 is not valid"));
            try {
                helper.assertValueEqual((Object)chestIn.getItem(0).getItem(), (Object)Items.CRAFTING_TABLE, (Component)Component.literal((String)"Slot 0 item is incorrect"));
                helper.assertValueEqual((Object)chestIn.getItem(0).getCount(), (Object)1, (Component)Component.literal((String)"Slot 0 amount is incorrect"));
                helper.assertValueEqual((Object)chestIn.getItem(1).getItem(), (Object)Items.OAK_PLANKS, (Component)Component.literal((String)"Slot 1 item is incorrect"));
                helper.assertValueEqual((Object)chestIn.getItem(1).getCount(), (Object)1, (Component)Component.literal((String)"Slot 1 amount is incorrect"));
                helper.assertValueEqual((Object)chestIn.getItem(2).getItem(), (Object)Items.CRAFTING_TABLE, (Component)Component.literal((String)"Slot 0 item is incorrect"));
                helper.assertValueEqual((Object)chestIn.getItem(2).getCount(), (Object)1, (Component)Component.literal((String)"Slot 0 amount is incorrect"));
            }
            catch (GameTestAssertException e) {
                helper.assertValueEqual((Object)chestIn.getItem(0).getItem(), (Object)Items.CRAFTING_TABLE, (Component)Component.literal((String)"Slot 0 item is incorrect"));
                helper.assertValueEqual((Object)chestIn.getItem(0).getCount(), (Object)2, (Component)Component.literal((String)"Slot 0 amount is incorrect"));
                helper.assertValueEqual((Object)chestIn.getItem(1).getItem(), (Object)Items.OAK_PLANKS, (Component)Component.literal((String)"Slot 1 item is incorrect"));
                helper.assertValueEqual((Object)chestIn.getItem(1).getCount(), (Object)1, (Component)Component.literal((String)"Slot 1 amount is incorrect"));
            }
        });
    }
}

