/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class BiolithState
extends SavedData {
    private final LinkedHashMap<ResourceKey<Biome>, LinkedHashSet<ResourceKey<Biome>>> biomeReplacements = new LinkedHashMap(64);
    private final ServerLevel world;

    private static <E> Codec<LinkedHashSet<E>> getLinkedHashSetCodec(Codec<E> entryCodec) {
        return entryCodec.listOf().xmap(LinkedHashSet::new, lhs -> lhs.stream().toList());
    }

    public static Codec<BiolithState> getCodec(SavedData.Context context) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceKey.codec((ResourceKey)Registries.BIOME), BiolithState.getLinkedHashSetCodec(ResourceKey.codec((ResourceKey)Registries.BIOME))).optionalFieldOf("biome_replacements", Map.of()).forGetter(biolithState -> biolithState.biomeReplacements), (App)BiolithState.getLinkedHashSetCodec(ResourceKey.codec((ResourceKey)Registries.BIOME)).listOf().optionalFieldOf("BiomeReplacementsList", List.of()).forGetter(biolithState -> List.of())).apply((Applicative)instance, (replacements, biomeReplacementsList) -> {
            if (!replacements.isEmpty()) {
                return BiolithState.unmarshall_v1(context, replacements);
            }
            if (!biomeReplacementsList.isEmpty()) {
                return BiolithState.unmarshall_v0(context, biomeReplacementsList);
            }
            return new BiolithState(context);
        }));
    }

    public static SavedDataType<BiolithState> getPersistentStateType(String name) {
        return new SavedDataType("biolith_" + name + "_state", BiolithState::new, BiolithState::getCodec, null);
    }

    public BiolithState(SavedData.Context context) {
        this.world = context.levelOrThrow();
    }

    private static BiolithState unmarshall_v0(SavedData.Context context, List<LinkedHashSet<ResourceKey<Biome>>> biomeReplacementsList) {
        BiolithState state = new BiolithState(context);
        state.biomeReplacements.clear();
        biomeReplacementsList.forEach(list -> {
            ResourceKey key = (ResourceKey)list.removeFirst();
            state.biomeReplacements.put((ResourceKey<Biome>)key, new LinkedHashSet(list));
        });
        state.setDirty();
        return state;
    }

    private static BiolithState unmarshall_v1(SavedData.Context context, Map<ResourceKey<Biome>, LinkedHashSet<ResourceKey<Biome>>> replacements) {
        BiolithState state = new BiolithState(context);
        state.biomeReplacements.clear();
        state.biomeReplacements.putAll(replacements);
        return state;
    }

    public void write() {
        this.setDirty();
        this.world.getDataStorage().saveAndJoin();
    }

    public Stream<ResourceKey<Biome>> getBiomeReplacements(ResourceKey<Biome> target) {
        if (this.biomeReplacements.containsKey(target)) {
            return this.biomeReplacements.get(target).stream();
        }
        return Stream.empty();
    }

    public void addBiomeReplacements(ResourceKey<Biome> target, Stream<ResourceKey<Biome>> replacements) {
        if (this.biomeReplacements.containsKey(target)) {
            replacements.forEachOrdered(this.biomeReplacements.get(target)::add);
        } else {
            this.biomeReplacements.put(target, replacements.collect(Collectors.toCollection(LinkedHashSet::new)));
        }
        this.setDirty();
    }

    public ResourceLocation getDimensionId() {
        if (this.world.dimensionTypeRegistration().unwrapKey().isEmpty()) {
            return ResourceLocation.fromNamespaceAndPath((String)"biolith", (String)"unregistered_dimension");
        }
        return ((ResourceKey)this.world.dimensionTypeRegistration().unwrapKey().get()).location();
    }

    public ResourceLocation getWorldId() {
        return this.world.dimension().location();
    }
}

