/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.data.BiomePlacementMarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class BiomePlacementLoader
extends SimplePreparableReloadListener<List<BiomePlacementMarshaller>> {
    public static final FileToIdConverter BIOME_PLACEMENT_FINDER = FileToIdConverter.json((String)"biolith/biome_placement");

    protected List<BiomePlacementMarshaller> prepare(ResourceManager manager, ProfilerFiller profiler) {
        profiler.startTick();
        ArrayList<BiomePlacementMarshaller> marshallers = new ArrayList<BiomePlacementMarshaller>();
        profiler.push("biolith/biome_placement");
        try {
            for (Map.Entry entry : BIOME_PLACEMENT_FINDER.listMatchingResources(manager).entrySet()) {
                Resource resource = (Resource)entry.getValue();
                profiler.push(resource.sourcePackId());
                try {
                    InputStream inputStream = resource.open();
                    try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                        profiler.push("parse");
                        JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        BiomePlacementMarshaller marshaller = BiomePlacementLoader.get(BiomePlacementMarshaller.CODEC, (JsonElement)jsonObject);
                        if (marshaller == null) {
                            throw new RuntimeException();
                        }
                        marshallers.add(marshaller);
                        profiler.pop();
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable closeBreak) {
                                throwable.addSuppressed(closeBreak);
                            }
                        }
                        throw throwable;
                    }
                    inputStream.close();
                }
                catch (RuntimeException runtimeBreak) {
                    Biolith.LOGGER.warn("Parsing error loading biome placement '{}': '{}'", (Object)resource.sourcePackId(), (Object)runtimeBreak);
                }
                profiler.pop();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        profiler.pop();
        profiler.endTick();
        return marshallers;
    }

    protected void apply(List<BiomePlacementMarshaller> marshallers, ResourceManager manager, ProfilerFiller profiler) {
        if (BiomeCoordinator.isServerStarted()) {
            Biolith.LOGGER.warn("Ignoring request to reload biome placement data while server is running.");
            return;
        }
        if (marshallers.size() > 0) {
            Biolith.LOGGER.info("Applying biome placement data from {} source(s).", (Object)marshallers.size());
        }
        BiomeCoordinator.OVERWORLD.clearFromData();
        BiomeCoordinator.NETHER.clearFromData();
        BiomeCoordinator.END.clearFromData();
        for (BiomePlacementMarshaller marshaller : marshallers) {
            marshaller.unmarshall();
        }
    }

    public static <R> R get(Decoder<R> decoder, JsonElement jsonElement) throws NullPointerException {
        return (R)decoder.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).result().orElseThrow();
    }
}

