/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.surface.SurfaceRuleCollector;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.SurfaceRules;

public record SurfaceGenerationMarshaller(List<SurfaceRuleMarshaller> surfaceRules) {
    public static final Codec<SurfaceGenerationMarshaller> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SurfaceRuleMarshaller.CODEC.listOf().optionalFieldOf("surface_rules", List.of()).forGetter(SurfaceGenerationMarshaller::surfaceRules)).apply((Applicative)instance, SurfaceGenerationMarshaller::new));

    public void unmarshall() {
        for (SurfaceRuleMarshaller surfaceRule : this.surfaceRules) {
            surfaceRule.unmarshall();
        }
    }

    public record SurfaceRuleMarshaller(ResourceKey<DimensionType> dimension, ResourceLocation rulesOwner, List<SurfaceRules.RuleSource> materialRules) {
        public static Codec<SurfaceRuleMarshaller> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.DIMENSION_TYPE).fieldOf("dimension").forGetter(SurfaceRuleMarshaller::dimension), (App)ResourceLocation.CODEC.fieldOf("rules_owner").forGetter(SurfaceRuleMarshaller::rulesOwner), (App)SurfaceRules.RuleSource.CODEC.listOf().optionalFieldOf("material_rules", List.of()).forGetter(SurfaceRuleMarshaller::materialRules)).apply((Applicative)instance, SurfaceRuleMarshaller::new));

        public void unmarshall() {
            if (this.dimension.equals((Object)BuiltinDimensionTypes.OVERWORLD)) {
                SurfaceRuleCollector.OVERWORLD.addFromData(this.rulesOwner, this.materialRules.toArray(new SurfaceRules.RuleSource[0]));
            } else if (this.dimension.equals((Object)BuiltinDimensionTypes.NETHER)) {
                SurfaceRuleCollector.NETHER.addFromData(this.rulesOwner, this.materialRules.toArray(new SurfaceRules.RuleSource[0]));
            } else if (this.dimension.equals((Object)BuiltinDimensionTypes.END)) {
                SurfaceRuleCollector.END.addFromData(this.rulesOwner, this.materialRules.toArray(new SurfaceRules.RuleSource[0]));
            } else {
                Biolith.LOGGER.warn("Ignored unknown dimension type '{}' while serializing surface generation.", (Object)this.dimension.location());
            }
        }
    }
}

